import { Group } from '../types';
import { FeaturesAction } from '../../client/types';
/**
 * Action Types for the Features group
 * @public
 */
export declare enum Action {
    UPDATE = "APP::FEATURES::UPDATE",
    REQUEST = "APP::FEATURES::REQUEST",
    /**
     * @deprecated as of 2.1.0. Use "APP::FEATURES::UPDATE" instead
     */
    REQUEST_UPDATE = "APP::FEATURES::REQUEST::UPDATE"
}
/**
 * Default options for Feature payloads
 * @public
 */
export interface Options {
    readonly id?: string;
}
/**
 * Payload options for APP::FEATURES::REQUEST
 * @public
 */
export interface RequestOptions extends Options {
    feature: Group;
    action?: string;
}
/**
 * Payload options for APP::FEATURES::REQUEST::UPDATE
 * @public
 * @deprecated as of 2.1.0. Use "APP::REQUEST::UPDATE" instead
 */
export interface RequestUpdateOptions extends Options {
    feature: FeaturesAction;
}
