import React from 'react';
import { Unsubscribe } from '@shopify/app-bridge';
import { AppBridgeContext } from '../../context';
import { History } from './router';
export interface Props {
    history: History;
}
/**
 * ClientRouter component
 *
 * @remarks
 * React component which keeps the Shopify admin url in sync with the app url
 *
 * @public
 */
export default class ClientRouter extends React.Component<Props, never> {
    static contextType: React.Context<import("../../context").IAppBridgeContext>;
    context: React.ContextType<typeof AppBridgeContext>;
    unsubscribe?: Unsubscribe;
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): null;
}
