import { Redirect } from '@shopify/app-bridge/actions';
import { Group } from '@shopify/app-bridge/actions/types';
export declare type Target = Exclude<keyof typeof Redirect.Action, 'ADMIN_SECTION'>;
export interface ActionProps {
    /** Content the action displays */
    content?: string;
    /** Should the action be styled as destructive */
    destructive?: boolean;
    /** Should the action be disabled */
    disabled?: boolean;
    /** Should the action be loading */
    loading?: boolean;
    /** Forces url to open in a new tab */
    external?: boolean;
    /** Use Polaris plain styling */
    plain?: boolean;
    /**
     * Where to display the target link
     * @default 'APP'
     */
    target?: Target;
    /** A destination to link to */
    url?: string;
    /** Callback when an action takes place */
    onAction?(): void;
}
export interface ActionGroupProps {
    /** Action group title */
    title: string;
    /** Use Polaris plain styling */
    plain?: boolean;
    /** List of actions */
    actions: ActionProps[];
}
export { Group };
