"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = void 0;
var Share_1 = require("../../actions/Share");
var type_validate_1 = require("../type-validate");
var utils_1 = require("../utils");
function validateAction(action) {
    var urlProvided = type_validate_1.matchesObject({ text: type_validate_1.makeOptional(type_validate_1.matchesString()), url: type_validate_1.matchesString() });
    var textProvided = type_validate_1.matchesObject({ text: type_validate_1.matchesString(), url: type_validate_1.makeOptional(type_validate_1.matchesString()) });
    var urlError = type_validate_1.validate(action, utils_1.createActionValidator(Share_1.Action, urlProvided));
    var textError = type_validate_1.validate(action, utils_1.createActionValidator(Share_1.Action, textProvided));
    if (!urlError || !textError) {
        return;
    }
    return Object.prototype.hasOwnProperty.call(action.payload, 'url') ? urlError : textError;
}
exports.validateAction = validateAction;
var Share_2 = require("../../actions/Share");
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Share_2.Action; } });
