/// <reference types="node" resolution-mode="require"/>
/**
 * Returns whether an environment variable has been set and is non-empty
 */
export declare function isSet(variable: string | undefined): boolean;
/**
 * Returns an object with environment variables from the specified CI environment.
 */
export declare function getCIMetadata(envName: string, envs: NodeJS.ProcessEnv): Metadata;
export interface Metadata {
    actor?: string;
    attempt?: string;
    branch?: string;
    build?: string;
    commitMessage?: string;
    commitSha?: string;
    run?: string;
    runNumber?: string;
    url?: string;
}
