import { OtelService } from '../../public/node/vendor/otel-js/service/types.js';
import { DefaultOtelServiceOptions } from '../../public/node/vendor/otel-js/service/DefaultOtelService/DefaultOtelService.js';
type MetricRecorder = 'console' | {
    type: 'otel';
    otel: Pick<OtelService, 'record'>;
};
interface Timing {
    active: number;
    network: number;
    prompt: number;
}
interface CreateMetricRecorderOptions {
    skipMetricAnalytics: boolean;
    otelOptions: Omit<DefaultOtelServiceOptions, 'env' | 'otelEndpoint'>;
}
interface RecordMetricsOptions {
    /** If true, don't log anything */
    skipMetricAnalytics: boolean;
    /** The CLI version running the command */
    cliVersion: string;
    /** The plug-in that owns the command */
    owningPlugin: string;
    /** The command name, e.g. `app dev` */
    command: string;
    /** The exit mode for the command */
    exitMode: string;
}
/**
 * Record reliability metrics.
 */
export declare function recordMetrics(options: RecordMetricsOptions, timing: Timing, recorderFactory?: (options: CreateMetricRecorderOptions) => MetricRecorder): Promise<void>;
export {};
