/// <reference types="react" />
/// <reference types="node" resolution-mode="require"/>
import { Logger, LogLevel } from '../../public/node/output.js';
import { Key, RenderOptions } from 'ink';
import { EventEmitter } from 'events';
interface RenderOnceOptions {
    logLevel?: LogLevel;
    logger?: Logger;
    renderOptions?: RenderOptions;
}
export declare function renderOnce(element: JSX.Element, { logLevel, logger, renderOptions }: RenderOnceOptions): string | undefined;
export declare function render(element: JSX.Element, options?: RenderOptions): Promise<unknown>;
export declare class Stdout extends EventEmitter {
    columns: number;
    rows: number;
    readonly frames: string[];
    private _lastFrame?;
    constructor(options: {
        columns?: number;
        rows?: number;
    });
    write: (frame: string) => void;
    lastFrame: () => string | undefined;
}
export declare function handleCtrlC(input: string, key: Key, exit?: () => void): void;
export {};
