import { collectLog, consoleLog, outputWhereAppropriate } from '../../public/node/output.js';
import { isUnitTest } from '../../public/node/context/local.js';
import { treeKill } from '../../public/node/tree-kill.js';
import { render as inkRender } from 'ink';
import { EventEmitter } from 'events';
export function renderOnce(element, { logLevel = 'info', logger = consoleLog, renderOptions }) {
    const { output, unmount } = renderString(element, renderOptions);
    if (output) {
        if (isUnitTest())
            collectLog(logLevel, output);
        outputWhereAppropriate(logLevel, logger, output, { skipUIEvent: true });
    }
    unmount();
    return output;
}
export async function render(element, options) {
    const { waitUntilExit } = inkRender(element, options);
    await waitUntilExit();
    // We need to wait for other pending tasks -- unmounting of the ink component -- to complete
    return new Promise((resolve) => setImmediate(resolve));
}
export class Stdout extends EventEmitter {
    constructor(options) {
        super();
        this.frames = [];
        this.write = (frame) => {
            this.frames.push(frame);
            this._lastFrame = frame;
        };
        this.lastFrame = () => {
            return this._lastFrame;
        };
        this.columns = options.columns ?? 80;
        this.rows = options.rows ?? 80;
    }
}
const renderString = (element, renderOptions) => {
    const columns = isUnitTest() ? 80 : process.stdout.columns;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const stdout = renderOptions?.stdout ?? new Stdout({ columns });
    const instance = inkRender(element, {
        stdout,
        debug: true,
        exitOnCtrlC: false,
        patchConsole: false,
    });
    return {
        output: stdout.lastFrame(),
        unmount: instance.unmount,
    };
};
export function handleCtrlC(input, key, exit = () => treeKill(process.pid, 'SIGINT')) {
    if (input === 'c' && key.ctrl) {
        // Exceptions thrown in hooks aren't caught by our errorHandler.
        exit();
    }
}
//# sourceMappingURL=ui.js.map