import { SelectInputProps, Item as SelectItem } from './SelectInput.js';
import { InfoTableProps } from './Prompts/InfoTable.js';
import { InfoMessageProps } from './Prompts/InfoMessage.js';
import { Message } from './Prompts/PromptLayout.js';
import { AbortSignal } from '../../../../public/node/abort.js';
import React, { ReactElement } from 'react';
export interface SearchResults<T> {
    data: SelectItem<T>[];
    meta?: {
        hasNextPage: boolean;
    };
}
export interface AutocompletePromptProps<T> {
    message: Message;
    choices: SelectInputProps<T>['items'];
    onSubmit: (value: T) => void;
    infoTable?: InfoTableProps['table'];
    hasMorePages?: boolean;
    search: (term: string) => Promise<SearchResults<T>>;
    abortSignal?: AbortSignal;
    infoMessage?: InfoMessageProps['message'];
}
declare function AutocompletePrompt<T>({ message, choices, infoTable, onSubmit, search, hasMorePages: initialHasMorePages, abortSignal, infoMessage, }: React.PropsWithChildren<AutocompletePromptProps<T>>): ReactElement | null;
export { AutocompletePrompt };
