import { TextInput } from './TextInput.js';
import { TokenizedText } from './TokenizedText.js';
import { InfoTable } from './Prompts/InfoTable.js';
import { handleCtrlC } from '../../ui.js';
import useLayout from '../hooks/use-layout.js';
import { messageWithPunctuation } from '../utilities.js';
import useAbortSignal from '../hooks/use-abort-signal.js';
import usePrompt, { PromptState } from '../hooks/use-prompt.js';
import React, { useCallback, useEffect, useState } from 'react';
import { Box, useApp, useInput, Text } from 'ink';
import figures from 'figures';
const DangerousConfirmationPrompt = ({ message, confirmation, infoTable, onSubmit, abortSignal, }) => {
    const validateAnswer = useCallback((value) => {
        return value === confirmation ? undefined : ['Value must be exactly', { userInput: confirmation }];
    }, [confirmation]);
    const { oneThird, twoThirds } = useLayout();
    const { promptState, setPromptState, answer, setAnswer } = usePrompt({
        initialAnswer: '',
    });
    const { exit: unmountInk } = useApp();
    const [error, setError] = useState(undefined);
    const color = promptState === PromptState.Error ? 'red' : 'cyan';
    const underline = new Array(oneThird - 3).fill('▔');
    const { isAborted } = useAbortSignal(abortSignal);
    useInput((input, key) => {
        handleCtrlC(input, key);
        if (key.escape) {
            setPromptState(PromptState.Cancelled);
            setError(undefined);
        }
        if (key.return) {
            const error = validateAnswer(answer);
            if (error) {
                setPromptState(PromptState.Error);
                setError(error);
            }
            else {
                setPromptState(PromptState.Submitted);
            }
        }
    });
    useEffect(() => {
        if (promptState === PromptState.Submitted) {
            onSubmit(true);
            unmountInk();
        }
        else if (promptState === PromptState.Cancelled) {
            onSubmit(false);
            unmountInk();
        }
    }, [onSubmit, promptState, unmountInk]);
    const completed = promptState === PromptState.Submitted || promptState === PromptState.Cancelled;
    return isAborted ? null : (React.createElement(Box, { flexDirection: "column", marginBottom: 1, width: twoThirds },
        React.createElement(Box, null,
            React.createElement(Box, { marginRight: 2 },
                React.createElement(Text, null, "?")),
            React.createElement(TokenizedText, { item: messageWithPunctuation(message) })),
        completed ? (React.createElement(CompletedPrompt, { cancelled: promptState === PromptState.Cancelled })) : (React.createElement(React.Fragment, null,
            React.createElement(Box, { flexDirection: "column", gap: 1, marginTop: 1, marginLeft: 3 },
                infoTable ? (React.createElement(Box, { paddingLeft: 2, borderStyle: "bold", borderLeft: true, borderRight: false, borderTop: false, borderBottom: false, flexDirection: "column", gap: 1 },
                    React.createElement(InfoTable, { table: infoTable }))) : null,
                React.createElement(Box, null,
                    React.createElement(TokenizedText, { item: ['Type', { userInput: confirmation }, 'to confirm, or press Escape to cancel.'] }))),
            React.createElement(Box, { flexDirection: "column", width: oneThird },
                React.createElement(Box, null,
                    React.createElement(Box, { marginRight: 2 },
                        React.createElement(Text, { color: color }, `>`)),
                    React.createElement(Box, { flexGrow: 1 },
                        React.createElement(TextInput, { value: answer, onChange: (answer) => {
                                setAnswer(answer);
                                setPromptState(PromptState.Idle);
                            }, defaultValue: "", color: color }))),
                React.createElement(Box, { marginLeft: 3 },
                    React.createElement(Text, { color: color }, underline)),
                promptState === PromptState.Error && error ? (React.createElement(Box, { marginLeft: 3 },
                    React.createElement(Text, { color: color },
                        React.createElement(TokenizedText, { item: error })))) : null)))));
};
const CompletedPrompt = ({ cancelled }) => (React.createElement(Box, null,
    React.createElement(Box, { marginRight: 2 }, cancelled ? React.createElement(Text, { color: "red" }, figures.cross) : React.createElement(Text, { color: "cyan" }, figures.tick)),
    React.createElement(Box, { flexGrow: 1 }, cancelled ? React.createElement(Text, { color: "red" }, "Cancelled") : React.createElement(Text, { color: "cyan" }, "Confirmed"))));
export { DangerousConfirmationPrompt };
//# sourceMappingURL=DangerousConfirmationPrompt.js.map