import { InfoMessageProps } from './InfoMessage.js';
import { InfoTableProps } from './InfoTable.js';
import { InlineToken, LinkToken, TokenItem } from '../TokenizedText.js';
import { AbortSignal } from '../../../../../public/node/abort.js';
import { PromptState } from '../../hooks/use-prompt.js';
import { ReactElement } from 'react';
export type Message = TokenItem<Exclude<InlineToken, LinkToken>>;
export interface PromptLayoutProps {
    message: Message;
    infoTable?: InfoTableProps['table'];
    abortSignal?: AbortSignal;
    infoMessage?: InfoMessageProps['message'];
    header?: ReactElement | null;
    state: PromptState;
    submittedAnswerLabel?: string;
    input: ReactElement;
}
declare const PromptLayout: ({ message, infoTable, abortSignal, infoMessage, header, state, input, submittedAnswerLabel, }: PromptLayoutProps) => ReactElement | null;
export { PromptLayout };
