/**
 * Perform an action optimistically. If it fails the first time, first initiate
 * a provided recovery procedure, then retry the action. If it fails again,
 * throw the error.
 *
 * This is useful for actions that may fail due to recoverable errors, such as
 * an expired token that can be refreshed. In this case, the recovery procedure
 * would refresh the token.
 *
 * @param performAction - The action to perform.
 * @param recoveryProcedure - The recovery procedure to perform if the action
 * fails the first time.
 */
export declare function performActionWithRetryAfterRecovery<T>(performAction: () => Promise<T>, recoveryProcedure: () => Promise<unknown>): Promise<T>;
