import { GraphQLVariables, GraphQLResponse } from './graphql.js';
/**
 * Executes a GraphQL query against the Partners API.
 *
 * @param query - GraphQL query to execute.
 * @param token - Partners token.
 * @param variables - GraphQL variables to pass to the query.
 * @returns The response of the query of generic type <T>.
 */
export declare function partnersRequest<T>(query: string, token: string, variables?: GraphQLVariables): Promise<T>;
export interface FunctionUploadUrlGenerateResponse {
    functionUploadUrlGenerate: {
        generatedUrlDetails: {
            url: string;
            moduleId: string;
            headers: {
                [key: string]: string;
            };
            maxBytes: number;
            maxSize: string;
        };
    };
}
/**
 * Request a URL from partners to which we will upload our function.
 *
 * @param token - Partners token.
 * @returns The response of the query.
 */
export declare function getFunctionUploadUrl(token: string): Promise<FunctionUploadUrlGenerateResponse>;
export declare const FunctionUploadUrlGenerateMutation: string;
/**
 * Sets the next deprecation date from [GraphQL response extensions](https://www.apollographql.com/docs/resources/graphql-glossary/#extensions)
 * if `response.extensions.deprecations` objects contain a `supportedUntilDate` (ISO 8601-formatted string).
 *
 * @param response - The response of the query.
 */
export declare function handleDeprecations<T>(response: GraphQLResponse<T>): void;
