import { GraphQLVariables, GraphQLResponse } from './graphql.js';
/**
 * Executes an org-scoped GraphQL query against the Developers API.
 *
 * @param orgId - The organization ID.
 * @param query - GraphQL query to execute.
 * @param token - Partners token.
 * @param variables - GraphQL variables to pass to the query.
 * @returns The response of the query of generic type <T>.
 */
export declare function orgScopedShopifyDevelopersRequest<T>(orgId: string, query: string, token: string, variables?: GraphQLVariables): Promise<T>;
/**
 * Sets the next deprecation date from [GraphQL response extensions](https://www.apollographql.com/docs/resources/graphql-glossary/#extensions)
 * if `response.extensions.deprecations` objects contain a `supportedUntilDate` (ISO 8601-formatted string).
 *
 * @param response - The response of the query.
 */
export declare function handleDeprecations<T>(response: GraphQLResponse<T>): void;
