import { CommandExitMode } from './analytics.js';
import { Interfaces } from '@oclif/core';
export declare function errorHandler(error: Error & {
    exitCode?: number | undefined;
}, config?: Interfaces.Config): Promise<void>;
/**
 * Sends an error to Bugsnag. This is configured automatically for uncaught errors from CLI commands, but can also be used to manually record an error.
 *
 * @returns the reported error (this may have been tweaked for better reporting), and a bool to indicate if the error was actually submitted or not
 */
export declare function sendErrorToBugsnag(error: unknown, exitMode: Omit<CommandExitMode, 'ok'>): Promise<{
    reported: false;
    error: unknown;
    unhandled: unknown;
} | {
    error: Error;
    reported: true;
    unhandled: boolean;
}>;
/**
 * If the given file path is within a node_modules folder, remove prefix up
 * to and including the node_modules folder.
 *
 * This gives us very consistent paths for errors generated by the CLI.
 */
export declare function cleanStackFrameFilePath({ currentFilePath, projectRoot, pluginLocations, }: {
    currentFilePath: string;
    projectRoot: string;
    pluginLocations: {
        name: string;
        pluginPath: string;
    }[];
}): string;
/**
 * Register a Bugsnag error listener to clean up stack traces for errors within plugin code.
 *
 */
export declare function registerCleanBugsnagErrorsFromWithinPlugins(config: Interfaces.Config): Promise<void>;
export declare function addBugsnagMetadata(event: any, config: Interfaces.Config): Promise<void>;
