import { Operation } from '@shopify/cli-kit/node/themes/types';
export function buildTheme(themeJson) {
    if (!themeJson)
        return;
    themeJson.processing ?? (themeJson.processing = false);
    themeJson.createdAtRuntime ?? (themeJson.createdAtRuntime = false);
    const { id, name, role, processing, createdAtRuntime } = themeJson;
    return {
        id,
        name,
        processing,
        createdAtRuntime,
        role: role === 'main' ? 'live' : role,
    };
}
export function buildChecksum(asset) {
    if (!asset)
        return;
    const { key, checksum } = asset;
    return { key, checksum };
}
export function buildThemeAsset(asset) {
    if (!asset)
        return;
    const { key, checksum, attachment, value } = asset;
    return { key, checksum, attachment, value };
}
export function buildBulkUploadResults(bulkUploadResponse, assets) {
    const results = [];
    if (!bulkUploadResponse)
        return results;
    bulkUploadResponse.forEach((bulkUpload, index) => {
        const asset = assets[index];
        results.push({
            key: asset?.key || '',
            success: bulkUpload.code === 200,
            errors: bulkUpload.body.errors || {},
            asset: bulkUpload.body.asset,
            operation: Operation.Upload,
        });
    });
    return results;
}
//# sourceMappingURL=factories.js.map