import type { PushMetricExporter } from '@opentelemetry/sdk-metrics';
import { MetricReader } from '@opentelemetry/sdk-metrics';
export interface InstantaneousMetricReaderOptions {
    /**
     * The backing exporter for the metric reader.
     */
    exporter: PushMetricExporter;
    /**
     * How much the export should be throttled in milliseconds.
     */
    throttleLimit: number;
}
export declare class InstantaneousMetricReader extends MetricReader {
    private readonly _exporter;
    constructor({ exporter, throttleLimit }: InstantaneousMetricReaderOptions);
    protected onForceFlush(): Promise<void>;
    protected onShutdown(): Promise<void>;
}
