import { DefaultMeterProvider } from './DefaultMeterProvider.js';
import { BaseOtelService } from '../BaseOtelService/BaseOtelService.js';
import { diag, DiagConsoleLogger, DiagLogLevel } from '@opentelemetry/api';
export class DefaultOtelService extends BaseOtelService {
    /**
     * Bootstraps an Otel exporter which can send Otel metrics to a dedicated Shopify supported collector endpoint.
     */
    constructor({ throttleLimit = 5000, env = 'local', serviceName, prefixMetric = false, metrics = {}, onRecord, meterProvider, useXhr = false, 
    // CLI addition
    otelEndpoint, }) {
        diag.setLogger(new DiagConsoleLogger(), ['production', 'staging'].includes(env) ? DiagLogLevel.ERROR : DiagLogLevel.INFO);
        super({
            serviceName,
            meterProvider: meterProvider ??
                new DefaultMeterProvider({
                    serviceName,
                    env,
                    throttleLimit,
                    useXhr,
                    // CLI addition
                    otelEndpoint,
                }),
            prefixMetric,
            metrics,
            onRecord,
        });
    }
    shutdown() {
        diag.disable();
        return super.shutdown();
    }
}
//# sourceMappingURL=DefaultOtelService.js.map