export function throttle(func, wait, { leading = true, trailing = true } = {}) {
    let lastArgs;
    let result;
    let context;
    let timeout = null;
    let previous = 0;
    function later() {
        previous = leading === false ? 0 : Date.now();
        timeout = null;
        if (lastArgs) {
            result = func.apply(context, lastArgs);
        }
        context = null;
        lastArgs = null;
    }
    return function (...args) {
        const now = Date.now();
        if (!previous && leading === false)
            previous = now;
        const remaining = wait - (now - previous);
        // eslint-disable-next-line @typescript-eslint/no-this-alias, consistent-this
        context = this;
        lastArgs = args;
        if (remaining <= 0 || remaining > wait) {
            if (timeout) {
                clearTimeout(timeout);
                timeout = null;
            }
            previous = now;
            if (lastArgs) {
                result = func.apply(context, lastArgs);
            }
            context = null;
            lastArgs = null;
        }
        else if (!timeout && trailing !== false) {
            timeout = setTimeout(later, remaining);
        }
        return result;
    };
}
//# sourceMappingURL=throttle.js.map