"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaults = defaults;
exports.replaceValue = replaceValue;
var _react = require("react");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var arr = [];
var each = arr.forEach;

// Copied from https://github.com/i18next/i18next-icu/blob/370027c829e240b36b2f6e5d648be35453c9e6d8/src/utils.js
function defaults(obj) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }
  each.call(args, function (source) {
    if (source) {
      for (var prop in source) {
        if (obj[prop] === undefined) {
          obj[prop] = source[prop];
        }
      }
    }
  });
  return obj;
}

/**
 * Replaces all occurrences of the specified text. Returns a new value with the replacements made.
 * This function supports replacing text with React elements and replacing values within
 * nested React elements/arrays.
 *
 * @param {string|object|Array} interpolated - The value to replace occurrences of the specified text in.
 * @param {string|RegExp} pattern - The text or regular expression to search for in the interpolated value.
 * @param {string|object|Array} replacement - The value to replace occurrences of the specified text with.
 * @returns {string|object|Array} A new value with the specified text replaced.
 */
function replaceValue(interpolated, pattern, replacement) {
  var _interpolated$props;
  switch (_typeof(interpolated)) {
    case 'string':
      {
        var split = interpolated.split(pattern);
        // Check if interpolated includes pattern
        //  && if String.prototype.replace wouldn't work because replacement is an object like a React element.
        if (split.length !== 1 && _typeof(replacement) === 'object') {
          // Return array w/ the replacement

          if (!replacement.key && /*#__PURE__*/(0, _react.isValidElement)(replacement)) {
            // eslint-disable-next-line no-param-reassign
            replacement = /*#__PURE__*/(0, _react.cloneElement)(replacement, {
              key: pattern.toString()
            });
          }
          return [split[0], replacement, split[1]].flat();
        }

        // interpolated and replacement are primitives
        return interpolated.replace(pattern, replacement);
      }
    case 'object':
      if (Array.isArray(interpolated)) {
        return interpolated.map(function (item) {
          return replaceValue(item, pattern, replacement);
        }).flat();
      }

      // Check if the interpolated object may be a React element w/ children.
      if (interpolated !== null && interpolated !== void 0 && (_interpolated$props = interpolated.props) !== null && _interpolated$props !== void 0 && _interpolated$props.children) {
        var newChildren = replaceValue(interpolated.props.children, pattern, replacement);
        if (newChildren !== interpolated.props.children) {
          return _objectSpread(_objectSpread({}, interpolated), {}, {
            props: _objectSpread(_objectSpread({}, interpolated.props), {}, {
              children: newChildren
            })
          });
        }
      }
  }

  // The interpolated element is something else, just return it
  return interpolated;
}