(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('react')) :
  typeof define === 'function' && define.amd ? define(['react'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.i18nextShopify = factory(global.react));
})(this, (function (react) { 'use strict';

  function _iterableToArrayLimit(r, l) {
    var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
    if (null != t) {
      var e,
        n,
        i,
        u,
        a = [],
        f = !0,
        o = !1;
      try {
        if (i = (t = t.call(r)).next, 0 === l) {
          if (Object(t) !== t) return;
          f = !1;
        } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
      } catch (r) {
        o = !0, n = r;
      } finally {
        try {
          if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return;
        } finally {
          if (o) throw n;
        }
      }
      return a;
    }
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _typeof(o) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, _typeof(o);
  }
  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
    }
  }
  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }
  function _defineProperty(obj, key, value) {
    key = _toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }
  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }
  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }
  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
    return arr2;
  }
  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function _toPrimitive(input, hint) {
    if (typeof input !== "object" || input === null) return input;
    var prim = input[Symbol.toPrimitive];
    if (prim !== undefined) {
      var res = prim.call(input, hint || "default");
      if (typeof res !== "object") return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (hint === "string" ? String : Number)(input);
  }
  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");
    return typeof key === "symbol" ? key : String(key);
  }

  var arr = [];
  var each = arr.forEach;

  // Copied from https://github.com/i18next/i18next-icu/blob/370027c829e240b36b2f6e5d648be35453c9e6d8/src/utils.js
  function defaults(obj) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    each.call(args, function (source) {
      if (source) {
        for (var prop in source) {
          if (obj[prop] === undefined) {
            obj[prop] = source[prop];
          }
        }
      }
    });
    return obj;
  }

  /**
   * Replaces all occurrences of the specified text. Returns a new value with the replacements made.
   * This function supports replacing text with React elements and replacing values within
   * nested React elements/arrays.
   *
   * @param {string|object|Array} interpolated - The value to replace occurrences of the specified text in.
   * @param {string|RegExp} pattern - The text or regular expression to search for in the interpolated value.
   * @param {string|object|Array} replacement - The value to replace occurrences of the specified text with.
   * @returns {string|object|Array} A new value with the specified text replaced.
   */
  function replaceValue(interpolated, pattern, replacement) {
    var _interpolated$props;
    switch (_typeof(interpolated)) {
      case 'string':
        {
          var split = interpolated.split(pattern);
          // Check if interpolated includes pattern
          //  && if String.prototype.replace wouldn't work because replacement is an object like a React element.
          if (split.length !== 1 && _typeof(replacement) === 'object') {
            // Return array w/ the replacement

            if (!replacement.key && react.isValidElement(replacement)) {
              // eslint-disable-next-line no-param-reassign
              replacement = react.cloneElement(replacement, {
                key: pattern.toString()
              });
            }
            return [split[0], replacement, split[1]].flat();
          }

          // interpolated and replacement are primitives
          return interpolated.replace(pattern, replacement);
        }
      case 'object':
        if (Array.isArray(interpolated)) {
          return interpolated.map(function (item) {
            return replaceValue(item, pattern, replacement);
          }).flat();
        }

        // Check if the interpolated object may be a React element w/ children.
        if (interpolated !== null && interpolated !== void 0 && (_interpolated$props = interpolated.props) !== null && _interpolated$props !== void 0 && _interpolated$props.children) {
          var newChildren = replaceValue(interpolated.props.children, pattern, replacement);
          if (newChildren !== interpolated.props.children) {
            return _objectSpread2(_objectSpread2({}, interpolated), {}, {
              props: _objectSpread2(_objectSpread2({}, interpolated.props), {}, {
                children: newChildren
              })
            });
          }
        }
    }

    // The interpolated element is something else, just return it
    return interpolated;
  }

  function getDefaults() {
    return {};
  }
  var MUSTACHE_FORMAT = /{{?\s*(\w+)\s*}}?/g;
  var ShopifyFormat = /*#__PURE__*/function () {
    function ShopifyFormat(options) {
      _classCallCheck(this, ShopifyFormat);
      this.type = 'i18nFormat';
      this.init(null, options);
    }
    _createClass(ShopifyFormat, [{
      key: "init",
      value: function init(i18next, options) {
        var i18nextOptions = i18next && i18next.options && i18next.options.i18nFormat || {};
        this.options = defaults(i18nextOptions, options, this.options || {}, getDefaults());
        this.i18next = i18next;
      }

      // Implement custom interpolation logic
      // While i18next and Shopify's format both use the mustache syntax for interpolation,
      // Shopify uses the `ordinal` interpolation for ordinal pluralization, while i18next uses `count`.
      // parse(res, options, lng, ns, key, info)
    }, {
      key: "parse",
      value: function parse(res, options) {
        var _this = this;
        // const hadSuccessfulLookup = info && info.resolved && info.resolved.res;

        if (res === null) {
          return res;
        }

        // returnObjects parameter can cause objects to be resolved, rather than a single string
        // Perform parsing/interpolation on each of it's values
        if (_typeof(res) === 'object') {
          var newRes = {};
          for (var _i = 0, _Object$entries = Object.entries(res); _i < _Object$entries.length; _i++) {
            var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
              key = _Object$entries$_i[0],
              value = _Object$entries$_i[1];
            newRes[key] = this.parse(value, options);
          }
          return newRes;
        }

        // Interpolations
        var matches = res.match(MUSTACHE_FORMAT);
        if (!matches) {
          return res;
        }
        var interpolated = res;
        matches.forEach(function (match) {
          var _value;
          var interpolation_key = match.replace(MUSTACHE_FORMAT, '$1');
          var value = interpolation_key === 'ordinal' ? options.count || options.ordinal : options[interpolation_key];

          // Cardinal and Ordinal pluralizations should be formatted according to their locale
          // eg. "1,234,567th" instead of "1234567th"
          // However `count` and `ordinal` can also be used as a non-plural variable
          if ((interpolation_key === 'ordinal' || interpolation_key === 'count') && typeof value === 'number') {
            value = new Intl.NumberFormat(_this.i18next.resolvedLanguage).format(value);
          }
          interpolated = replaceValue(interpolated, match, (_value = value) !== null && _value !== void 0 ? _value : '');
        });
        return interpolated;
      }

      // Add any other locations that should be searched first for an answer to the lookup
      // Add keys to `finalKeys` in reverse order (e.g., least specific -> most specific)
      // Useful when defining keys for pluralization or other context cases (e.g., grammatical gender)
    }, {
      key: "addLookupKeys",
      value: function addLookupKeys(finalKeys, key, code, ns, options) {
        var needsPluralHandling = Boolean(options.count !== undefined && typeof options.count !== 'string' || typeof options.ordinal === 'number');
        if (needsPluralHandling) {
          if (!this.i18next.translator.pluralResolver.shouldUseIntlApi()) {
            throw new Error('Error: The application was unable to use the Intl API. This may be due to a missing or incomplete polyfill.');
          }

          // Shopify uses the "ordinal" interpolation for ordinal pluralization (i.e., {{ordinal}}), users will expect to
          // do lookups with `i18n.t("key", { ordinal: 1 })`.
          // However, the i18next pluralization system uses the "count" option for both cardinal and ordinal pluralization
          // so users will expect to do lookups with `i18n.t("key", { count: 1, ordinal: true })`.
          // So we support either, using count if provided.
          // There is an edge case: if `ordinal` were set explicitly to 0, and `count` is provided, we behave as i18next
          // does, treating it as cardinal pluralization.
          var needsOrdinalHandling = Boolean(options.ordinal || options.ordinal === 0 && options.count === undefined);
          var pluralRule = this.i18next.translator.pluralResolver.getRule(code, _objectSpread2(_objectSpread2({}, options), {}, {
            ordinal: needsOrdinalHandling
          }));
          if (needsOrdinalHandling) {
            var ruleName = pluralRule.select(options.count === undefined ? options.ordinal : options.count);
            var pluralSuffix = "".concat(this.i18next.options.keySeparator, "ordinal").concat(this.i18next.options.keySeparator).concat(ruleName);
            finalKeys.push(key + pluralSuffix);
          } else {
            var _ruleName = pluralRule.select(options.count);

            // Fallback to "other" key
            if (_ruleName !== 'other') {
              var otherSubkey = "".concat(this.i18next.options.keySeparator, "other");
              finalKeys.push(key + otherSubkey);
            }

            // Pluralization rule key
            var _pluralSuffix = "".concat(this.i18next.options.keySeparator).concat(_ruleName);
            finalKeys.push(key + _pluralSuffix);

            // Explicit "0" and "1" keys
            if (options.count === 0) {
              var explicit0Subkey = "".concat(this.i18next.options.keySeparator, "0");
              finalKeys.push(key + explicit0Subkey);
            } else if (options.count === 1) {
              var explicit1Subkey = "".concat(this.i18next.options.keySeparator, "1");
              finalKeys.push(key + explicit1Subkey);
            }
          }
        }
        return finalKeys;
      }
    }]);
    return ShopifyFormat;
  }();
  ShopifyFormat.type = 'i18nFormat';

  return ShopifyFormat;

}));
