var _a;
import { autocorrectStatus } from '../../../services/constants.js';
import { setAutocorrect } from '../../../services/conf.js';
import Command from '@shopify/cli-kit/node/base-command';
import { renderInfo } from '@shopify/cli-kit/node/ui';
class AutocorrectOff extends Command {
    async run() {
        setAutocorrect(false);
        renderInfo({ body: autocorrectStatus.off });
    }
}
_a = AutocorrectOff;
AutocorrectOff.summary = 'Disable autocorrect. Off by default.';
AutocorrectOff.descriptionWithMarkdown = `Disable autocorrect. Off by default.

  When autocorrection is enabled, Shopify CLI automatically runs a corrected version of your command if a correction is available.

  When autocorrection is disabled, you need to confirm that you want to run corrections for mistyped commands.
`;
AutocorrectOff.description = _a.descriptionWithoutMarkdown();
export default AutocorrectOff;
//# sourceMappingURL=off.js.map