var _a;
import { autocorrectStatus } from '../../../services/constants.js';
import { setAutocorrect } from '../../../services/conf.js';
import Command from '@shopify/cli-kit/node/base-command';
import { renderInfo } from '@shopify/cli-kit/node/ui';
class AutocorrectOn extends Command {
    async run() {
        setAutocorrect(true);
        renderInfo({ body: autocorrectStatus.on });
    }
}
_a = AutocorrectOn;
AutocorrectOn.summary = 'Enable autocorrect. Off by default.';
AutocorrectOn.descriptionWithMarkdown = `Enable autocorrect. Off by default.

  When autocorrection is enabled, Shopify CLI automatically runs a corrected version of your command if a correction is available.

  When autocorrection is disabled, you need to confirm that you want to run corrections for mistyped commands.
`;
AutocorrectOn.description = _a.descriptionWithoutMarkdown();
export default AutocorrectOn;
//# sourceMappingURL=on.js.map