import { gray } from '../colors.mjs';
import { createMetaThemePartial, createMetaTheme } from './utils.mjs';

var metaThemeDarkPartial = createMetaThemePartial({
  color: {
    'color-scheme': {
      value: 'dark'
    },
    'color-bg': {
      value: gray[16]
    },
    'color-bg-surface': {
      value: gray[15]
    },
    'color-bg-fill': {
      value: gray[15]
    },
    'color-icon': {
      value: gray[8]
    },
    'color-icon-secondary': {
      value: gray[12]
    },
    'color-text': {
      value: gray[8]
    },
    'color-text-secondary': {
      value: gray[11]
    },
    'color-bg-surface-secondary-active': {
      value: gray[13]
    },
    'color-bg-surface-secondary-hover': {
      value: gray[14]
    }
  }
});
var metaThemeDark = createMetaTheme(metaThemeDarkPartial);

export { metaThemeDark, metaThemeDarkPartial };
