"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractMigrationEngine = void 0;
var tslib_1 = require("tslib");
var types_1 = require("./types");
var AbstractMigrationEngine = /** @class */ (function () {
    function AbstractMigrationEngine(db, opts, migrations) {
        if (opts === void 0) { opts = {}; }
        this.options = tslib_1.__assign(tslib_1.__assign({}, types_1.defaultSessionStorageMigratorOptions), opts);
        this.connection = db;
        this.migrations = migrations;
        this.ready = this.initMigrationPersistence();
    }
    AbstractMigrationEngine.prototype.applyMigrations = function (databaseReady) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _a, _b, _c, migrationName, migrationFunction, migrationApplied, e_1_1;
            var e_1, _d;
            return tslib_1.__generator(this, function (_e) {
                switch (_e.label) {
                    case 0: return [4 /*yield*/, databaseReady];
                    case 1:
                        _e.sent();
                        return [4 /*yield*/, this.ready];
                    case 2:
                        _e.sent();
                        _e.label = 3;
                    case 3:
                        _e.trys.push([3, 10, 11, 12]);
                        _a = tslib_1.__values(this.getMigrationList()), _b = _a.next();
                        _e.label = 4;
                    case 4:
                        if (!!_b.done) return [3 /*break*/, 9];
                        _c = _b.value, migrationName = _c.migrationName, migrationFunction = _c.migrationFunction;
                        return [4 /*yield*/, this.hasMigrationBeenApplied(migrationName)];
                    case 5:
                        migrationApplied = _e.sent();
                        if (!!migrationApplied) return [3 /*break*/, 8];
                        return [4 /*yield*/, migrationFunction(this.connection)];
                    case 6:
                        _e.sent();
                        return [4 /*yield*/, this.saveAppliedMigration(migrationName)];
                    case 7:
                        _e.sent();
                        _e.label = 8;
                    case 8:
                        _b = _a.next();
                        return [3 /*break*/, 4];
                    case 9: return [3 /*break*/, 12];
                    case 10:
                        e_1_1 = _e.sent();
                        e_1 = { error: e_1_1 };
                        return [3 /*break*/, 12];
                    case 11:
                        try {
                            if (_b && !_b.done && (_d = _a.return)) _d.call(_a);
                        }
                        finally { if (e_1) throw e_1.error; }
                        return [7 /*endfinally*/];
                    case 12: return [2 /*return*/, Promise.resolve()];
                }
            });
        });
    };
    AbstractMigrationEngine.prototype.getMigrationList = function () {
        return this.migrations;
    };
    return AbstractMigrationEngine;
}());
exports.AbstractMigrationEngine = AbstractMigrationEngine;
//# sourceMappingURL=abstract-migration-engine.js.map