const CLIENT = "GraphQL Client";
const MIN_RETRIES = 0;
const MAX_RETRIES = 3;
const GQL_API_ERROR = "An error occurred while fetching from the API. Review 'graphQLErrors' for details.";
const UNEXPECTED_CONTENT_TYPE_ERROR = "Response returned unexpected Content-Type:";
const NO_DATA_OR_ERRORS_ERROR = "An unknown error has occurred. The API did not return a data object or any errors in its response.";
const CONTENT_TYPES = {
    json: "application/json",
    multipart: "multipart/mixed",
};
const SDK_VARIANT_HEADER = "X-SDK-Variant";
const SDK_VERSION_HEADER = "X-SDK-Version";
const DEFAULT_SDK_VARIANT = "shopify-graphql-client";
// This is value is replaced with package.json version during rollup build process
const DEFAULT_CLIENT_VERSION = "0.10.3";
const RETRY_WAIT_TIME = 1000;
const RETRIABLE_STATUS_CODES = [429, 503];
const DEFER_OPERATION_REGEX = /@(defer)\b/i;
const NEWLINE_SEPARATOR = "\r\n";
const BOUNDARY_HEADER_REGEX = /boundary="?([^=";]+)"?/i;
const HEADER_SEPARATOR = NEWLINE_SEPARATOR + NEWLINE_SEPARATOR;

export { BOUNDARY_HEADER_REGEX, CLIENT, CONTENT_TYPES, DEFAULT_CLIENT_VERSION, DEFAULT_SDK_VARIANT, DEFER_OPERATION_REGEX, GQL_API_ERROR, HEADER_SEPARATOR, MAX_RETRIES, MIN_RETRIES, NEWLINE_SEPARATOR, NO_DATA_OR_ERRORS_ERROR, RETRIABLE_STATUS_CODES, RETRY_WAIT_TIME, SDK_VARIANT_HEADER, SDK_VERSION_HEADER, UNEXPECTED_CONTENT_TYPE_ERROR };
//# sourceMappingURL=constants.mjs.map
