import { MIN_RETRIES, MAX_RETRIES, CLIENT } from './constants.mjs';

function formatErrorMessage(message, client = CLIENT) {
    return message.startsWith(`${client}`) ? message : `${client}: ${message}`;
}
function getErrorMessage(error) {
    return error instanceof Error ? error.message : JSON.stringify(error);
}
function getErrorCause(error) {
    return error instanceof Error && error.cause ? error.cause : undefined;
}
function combineErrors(dataArray) {
    return dataArray.flatMap(({ errors }) => {
        return errors ?? [];
    });
}
function validateRetries({ client, retries, }) {
    if (retries !== undefined &&
        (typeof retries !== "number" ||
            retries < MIN_RETRIES ||
            retries > MAX_RETRIES)) {
        throw new Error(`${client}: The provided "retries" value (${retries}) is invalid - it cannot be less than ${MIN_RETRIES} or greater than ${MAX_RETRIES}`);
    }
}
function getKeyValueIfValid(key, value) {
    return value &&
        (typeof value !== "object" ||
            Array.isArray(value) ||
            (typeof value === "object" && Object.keys(value).length > 0))
        ? { [key]: value }
        : {};
}
function buildDataObjectByPath(path, data) {
    if (path.length === 0) {
        return data;
    }
    const key = path.pop();
    const newData = {
        [key]: data,
    };
    if (path.length === 0) {
        return newData;
    }
    return buildDataObjectByPath(path, newData);
}
function combineObjects(baseObject, newObject) {
    return Object.keys(newObject || {}).reduce((acc, key) => {
        if ((typeof newObject[key] === "object" || Array.isArray(newObject[key])) &&
            baseObject[key]) {
            acc[key] = combineObjects(baseObject[key], newObject[key]);
            return acc;
        }
        acc[key] = newObject[key];
        return acc;
    }, Array.isArray(baseObject) ? [...baseObject] : { ...baseObject });
}
function buildCombinedDataObject([initialDatum, ...remainingData]) {
    return remainingData.reduce(combineObjects, { ...initialDatum });
}

export { buildCombinedDataObject, buildDataObjectByPath, combineErrors, formatErrorMessage, getErrorCause, getErrorMessage, getKeyValueIfValid, validateRetries };
//# sourceMappingURL=utilities.mjs.map
