import { ApiClient, ApiClientRequestStream, ApiClientConfig, CustomFetchApi, ApiClientLogger, ApiClientLogContentTypes } from '@shopify/graphql-client';
export { AllOperations, ApiClientRequestOptions, ClientResponse, FetchResponseBody, HTTPResponseLog, HTTPRetryLog, LogContent, ResponseWithType, ReturnData } from '@shopify/graphql-client';

type StorefrontApiClientLogContentTypes = ApiClientLogContentTypes;
type StorefrontApiClientConfig = ApiClientConfig & {
    clientName?: string;
} & ({
    publicAccessToken?: never;
    privateAccessToken: string;
} | {
    publicAccessToken: string;
    privateAccessToken?: never;
});
type StorefrontApiClientOptions = Omit<StorefrontApiClientConfig, "headers" | "apiUrl"> & {
    customFetchApi?: CustomFetchApi;
    logger?: ApiClientLogger<StorefrontApiClientLogContentTypes>;
};
interface StorefrontQueries {
    [key: string]: {
        variables: any;
        return: any;
    };
    [key: number | symbol]: never;
}
interface StorefrontMutations {
    [key: string]: {
        variables: any;
        return: any;
    };
    [key: number | symbol]: never;
}
type StorefrontOperations = StorefrontQueries & StorefrontMutations;
type StorefrontApiClient = ApiClient<StorefrontApiClientConfig, StorefrontOperations> & {
    requestStream: ApiClientRequestStream<StorefrontOperations>;
};

declare function createStorefrontApiClient({ storeDomain, apiVersion, publicAccessToken, privateAccessToken, clientName, retries, customFetchApi, logger, }: StorefrontApiClientOptions): StorefrontApiClient;

export { type StorefrontApiClient, type StorefrontMutations, type StorefrontOperations, type StorefrontQueries, createStorefrontApiClient };
