"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.downloadThemeLiquidDocs = exports.exists = exports.downloadFile = exports.Resources = void 0;
const promises_1 = __importDefault(require("node:fs/promises"));
const node_fetch_1 = __importDefault(require("node-fetch"));
const node_path_1 = __importDefault(require("node:path"));
exports.Resources = [
    'filters',
    'objects',
    'tags',
    'section_schema',
    'translations_schema',
    'shopify_system_translations',
];
const THEME_LIQUID_DOCS = {
    filters: 'data/filters.json',
    objects: 'data/objects.json',
    tags: 'data/tags.json',
    latest: 'data/latest.json',
    section_schema: 'schemas/theme/section_schema.json',
    translations_schema: 'schemas/theme/translations_schema.json',
    shopify_system_translations: 'data/shopify_system_translations.json',
};
async function downloadFile(file, destination) {
    const remotePath = buildRemotePath(file);
    const localPath = buildLocalPath(file, destination);
    const res = await (0, node_fetch_1.default)(remotePath);
    const text = await res.text();
    return promises_1.default.writeFile(localPath, text, 'utf8');
}
exports.downloadFile = downloadFile;
function buildRemotePath(file) {
    const relativePath = THEME_LIQUID_DOCS[file];
    return `https://raw.githubusercontent.com/Shopify/theme-liquid-docs/main/${relativePath}`;
}
function buildLocalPath(file, destination) {
    return node_path_1.default.join(destination, `${file}.json`);
}
async function exists(path) {
    try {
        await promises_1.default.stat(path);
        return true;
    }
    catch (e) {
        return false;
    }
}
exports.exists = exists;
async function downloadThemeLiquidDocs(outputDir) {
    if (!(await exists(outputDir))) {
        await promises_1.default.mkdir(outputDir);
    }
    const promises = ['latest'].concat(exports.Resources).map((file) => {
        return downloadFile(file, outputDir);
    });
    await Promise.all(promises);
}
exports.downloadThemeLiquidDocs = downloadThemeLiquidDocs;
//# sourceMappingURL=themeLiquidDocsDownloader.js.map