import { Resource } from './themeLiquidDocsDownloader';
export declare const noop: () => void;
export declare const root: string;
export declare function download(file: Resource | 'latest', destination?: string): Promise<void>;
export declare function filePath(file: Resource | 'latest', destination?: string): string;
/** Returns a cached version of a function. Only caches one result. */
export declare function memo<F extends (...args: any[]) => any>(fn: F): (...args: ArgumentTypes<F>) => ReturnType<F>;
/**
 * ArgumentTypes extracts the type of the arguments of a function.
 *
 * @example
 *
 * function doStuff(a: number, b: string) {
 *   // do stuff
 * }
 *
 * type DoStuffArgs = ArgumentTypes<typeof doStuff> // = [number, string].
 */
type ArgumentTypes<F extends Function> = F extends (...args: infer T) => void ? T : never;
export {};
