import { AbsolutePath, Config } from '@shopify/theme-check-common';
import { ConfigDescription } from './types';
/**
 * Creates the checks array, loads node modules checks and validates
 * settings against the respective check schemas.
 *
 * Effectively "loads" a ConfigDescription into a Config.
 */
export declare function loadConfigDescription(configDescription: ConfigDescription, root: AbsolutePath): Promise<Config>;
/**
 * @param root - absolute path of the config file
 * @param pathLike - resolved textual value of the `root` property from the config files
 * @returns {string} resolved absolute path of the root property
 */
export declare function resolveRoot(root: AbsolutePath, pathLike: string | undefined): string;
