"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadConfig = void 0;
const resolve_1 = require("./resolve");
const load_config_description_1 = require("./load-config-description");
const validation_1 = require("./validation");
/**
 * Given an absolute path to a config file, this function returns
 * the validated Config object that it represents.
 *
 * In detail, it does the following:
 *  - resolves and merges extended config,
 *  - resolves the absolute path of the root,
 *  - loads community-provided checks,
 *  - validates check settings.
 */
async function loadConfig(
/** The absolute path of config file */
configPath, 
/** The root of the theme */
root) {
    if (!root)
        throw new Error('loadConfig cannot be called without a root argument');
    const configDescription = await (0, resolve_1.resolveConfig)(configPath !== null && configPath !== void 0 ? configPath : 'theme-check:recommended', true);
    const config = await (0, load_config_description_1.loadConfigDescription)(configDescription, root);
    (0, validation_1.validateConfig)(config);
    return config;
}
exports.loadConfig = loadConfig;
//# sourceMappingURL=load-config.js.map