import { AbsolutePath } from '@shopify/theme-check-common';
export interface PathHandler<T> {
    join(base: T, ...paths: (T | string)[]): AbsolutePath;
    dirname(path: T): T;
    asPath(path: T): string;
}
/**
 * This more complex version of findRoot is used in the language server so that we can
 * use URIs instead of strings. It's also used in the CLI.
 */
export declare function reusableFindRoot<T>(curr: T, path: PathHandler<T>): Promise<T>;
/**
 * Returns the "root" of a theme or theme app extension. The root is the
 * directory that contains a `.theme-check.yml` file, a `.git` directory, or a
 * `shopify.extension.toml` file.
 *
 * There are cases where .theme-check.yml is not defined and we have to infer the root.
 * We'll assume that the root is the directory that contains a `snippets` directory.
 *
 * So you can think of this function as the function that infers where a .theme-check.yml
 * should be.
 */
export declare function findRoot(curr: AbsolutePath): Promise<AbsolutePath>;
