"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findRoot = exports.reusableFindRoot = void 0;
const path = __importStar(require("path"));
const file_utils_1 = require("./file-utils");
async function isRoot(dir, path) {
    return or((0, file_utils_1.fileExists)(path.join(dir, 'shopify.extension.toml')), // for theme-app-extensions
    (0, file_utils_1.fileExists)(path.join(dir, '.theme-check.yml')), (0, file_utils_1.fileExists)(path.join(dir, '.git')), 
    // zip files and TAEs might not have config files, but they should have a
    // snippets directory but in case they do specify a .theme-check.yml a
    // couple of directories up, we should respect that
    and((0, file_utils_1.fileExists)(path.join(dir, 'snippets')), not((0, file_utils_1.fileExists)(path.join(path.dirname(dir), '.theme-check.yml'))), not((0, file_utils_1.fileExists)(path.join(path.dirname(path.dirname(dir)), '.theme-check.yml')))));
}
async function and(...promises) {
    const bools = await Promise.all(promises);
    return bools.reduce((a, b) => a && b, true);
}
async function or(...promises) {
    const bools = await Promise.all(promises);
    return bools.reduce((a, b) => a || b, false);
}
async function not(ap) {
    const a = await ap;
    return !a;
}
const FilePathHandler = {
    join(base, ...paths) {
        return path.join(base, ...paths);
    },
    dirname(pathStr) {
        return path.dirname(pathStr);
    },
    asPath(pathStr) {
        return pathStr;
    },
};
/**
 * This more complex version of findRoot is used in the language server so that we can
 * use URIs instead of strings. It's also used in the CLI.
 */
async function reusableFindRoot(curr, path) {
    const currIsRoot = await isRoot(curr, path);
    if (currIsRoot) {
        return curr;
    }
    const dir = path.dirname(curr);
    const currIsAbsoluteRoot = dir === curr;
    if (currIsAbsoluteRoot) {
        return curr;
    }
    return reusableFindRoot(dir, path);
}
exports.reusableFindRoot = reusableFindRoot;
/**
 * Returns the "root" of a theme or theme app extension. The root is the
 * directory that contains a `.theme-check.yml` file, a `.git` directory, or a
 * `shopify.extension.toml` file.
 *
 * There are cases where .theme-check.yml is not defined and we have to infer the root.
 * We'll assume that the root is the directory that contains a `snippets` directory.
 *
 * So you can think of this function as the function that infers where a .theme-check.yml
 * should be.
 */
async function findRoot(curr) {
    return reusableFindRoot(curr, FilePathHandler);
}
exports.findRoot = findRoot;
//# sourceMappingURL=find-root.js.map