import { Config, JSONSourceCode, LiquidSourceCode, Offense, Theme } from '@shopify/theme-check-common';
import { loadConfig as resolveConfig } from './config';
export * from '@shopify/theme-check-common';
export * from './config/types';
export { PathHandler, findRoot, reusableFindRoot } from './find-root';
export declare const loadConfig: typeof resolveConfig;
export type ThemeCheckRun = {
    theme: Theme;
    config: Config;
    offenses: Offense[];
};
export declare function toSourceCode(absolutePath: string): Promise<LiquidSourceCode | JSONSourceCode | undefined>;
export declare function check(root: string, configPath?: string): Promise<Offense[]>;
export declare function checkAndAutofix(root: string, configPath?: string): Promise<void>;
export declare function themeCheckRun(root: string, configPath?: string): Promise<ThemeCheckRun>;
export declare function getTheme(config: Config): Promise<Theme>;
