'use strict';

const metadata = {
  "AbandonedCartMajor": {
    "id": "AbandonedCartMajor",
    "name": "Abandoned cart",
    "set": "major",
    "description": "Used to represent a prospective purchase that a buyer didn’t complete.",
    "keywords": [
      "orders",
      "sales",
      "funnel"
    ]
  },
  "AccessibilityMajor": {
    "id": "AccessibilityMajor",
    "name": "Accessibility",
    "set": "major",
    "description": "Used to represent accessibility information or features.",
    "keywords": [
      "accessibility",
      "usability",
      "a11y",
      "disability",
      "equal access",
      "universal design",
      "eye"
    ]
  },
  "ActivitiesMajor": {
    "id": "ActivitiesMajor",
    "name": "Activities",
    "set": "major",
    "description": "Used as a navigation item in our emoji picker for the activities category.",
    "keywords": [
      "emoji",
      "navigation",
      "football",
      "ball",
      "activity"
    ]
  },
  "AddCodeMajor": {
    "id": "AddCodeMajor",
    "name": "Add code",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AddImageMajor": {
    "id": "AddImageMajor",
    "name": "Add image",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AddMajor": {
    "id": "AddMajor",
    "name": "Add",
    "set": "major",
    "description": "Used as an action to add a new content block or layout component.",
    "keywords": [
      "add",
      "new",
      "block"
    ]
  },
  "AddNoteMajor": {
    "id": "AddNoteMajor",
    "name": "Add note",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AddProductMajor": {
    "id": "AddProductMajor",
    "name": "Add product",
    "set": "major",
    "description": "Used as an action to add a new product.",
    "keywords": [
      "add",
      "product",
      "price tag"
    ]
  },
  "AdjustMinor": {
    "id": "AdjustMinor",
    "name": "Adjust",
    "set": "minor",
    "description": "Used to denote that an adjustment can be made.",
    "keywords": [
      "adjust",
      "adjustment",
      "controls",
      "dials"
    ]
  },
  "AffiliateMajor": {
    "id": "AffiliateMajor",
    "name": "Affiliate",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AlertMinor": {
    "id": "AlertMinor",
    "name": "Alert",
    "set": "minor",
    "description": "Used to give merchants more information about something they should be aware of.",
    "keywords": [
      "attention",
      "alert",
      "warning",
      "exclamation",
      "bang"
    ]
  },
  "AnalyticsBarHorizontalMinor": {
    "id": "AnalyticsBarHorizontalMinor",
    "name": "AnalyticsBarHorizontal",
    "set": "minor",
    "description": "Used to represent a horizontal bar chart.",
    "keywords": [
      "analytics",
      "graph",
      "horizontal bar chart"
    ]
  },
  "AnalyticsBarStackedMinor": {
    "id": "AnalyticsBarStackedMinor",
    "name": "AnalyticsBarStacked",
    "set": "minor",
    "description": "Used to represent a stacked bar chart.",
    "keywords": [
      "analytics",
      "graph",
      "stacked bar chart"
    ]
  },
  "AnalyticsCohortMinor": {
    "id": "AnalyticsCohortMinor",
    "name": "AnalyticsCohort",
    "set": "minor",
    "description": "Used to represent a cohort analysis.",
    "keywords": [
      "analytics",
      "graph",
      "cohort analysis",
      "reports"
    ]
  },
  "AnalyticsDonutMinor": {
    "id": "AnalyticsDonutMinor",
    "name": "AnalyticsDonut",
    "set": "minor",
    "description": "Used to represent a donut chart.",
    "keywords": [
      "analytics",
      "graph",
      "donut chart"
    ]
  },
  "AnalyticsFunnelMinor": {
    "id": "AnalyticsFunnelMinor",
    "name": "AnalyticsFunnel",
    "set": "minor",
    "description": "Used to represent a funnel chart.",
    "keywords": [
      "analytics",
      "graph",
      "funnel chart"
    ]
  },
  "AnalyticsLineMinor": {
    "id": "AnalyticsLineMinor",
    "name": "AnalyticsLine",
    "set": "minor",
    "description": "Used to represent a line chart.",
    "keywords": [
      "analytics",
      "graph",
      "line chart"
    ]
  },
  "AnalyticsMajor": {
    "id": "AnalyticsMajor",
    "name": "Analytics",
    "set": "major",
    "description": "Used to represent analytics or data.",
    "keywords": [
      "analytics",
      "data",
      "graph",
      "reports"
    ]
  },
  "AnalyticsMinor": {
    "id": "AnalyticsMinor",
    "name": "Analytics",
    "set": "minor",
    "description": "Used to represent analytics or data.",
    "keywords": [
      "analytics",
      "data",
      "graph",
      "reports"
    ]
  },
  "AnalyticsTableMinor": {
    "id": "AnalyticsTableMinor",
    "name": "AnalyticsTable",
    "set": "minor",
    "description": "Used to represent a data table.",
    "keywords": [
      "analytics",
      "data table"
    ]
  },
  "AnyClickModelMinor": {
    "id": "AnyClickModelMinor",
    "name": "Any click attribution model",
    "set": "minor",
    "description": "Used to represent the any click marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "any click"
    ]
  },
  "AppExtensionMinor": {
    "id": "AppExtensionMinor",
    "name": "App extension",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AppsMajor": {
    "id": "AppsMajor",
    "name": "Apps",
    "set": "major",
    "description": "Used to represent partner apps.",
    "keywords": [
      "add",
      "apps",
      "applications",
      "blocks",
      "embedded",
      "extensions"
    ]
  },
  "AppsMinor": {
    "id": "AppsMinor",
    "name": "Apps",
    "set": "minor",
    "description": "Used to represent partner apps.",
    "keywords": [
      "add",
      "apps",
      "applications",
      "blocks",
      "embedded",
      "extensions"
    ]
  },
  "ArchiveMajor": {
    "id": "ArchiveMajor",
    "name": "Archive",
    "set": "major",
    "description": "Used to represent archiving an item or resource.",
    "keywords": [
      "archive",
      "box"
    ]
  },
  "ArchiveMinor": {
    "id": "ArchiveMinor",
    "name": "Archive",
    "set": "minor",
    "description": "Used to denote the action of archiving an item or resource.",
    "keywords": [
      "archive",
      "box"
    ]
  },
  "ArrowDownMinor": {
    "id": "ArrowDownMinor",
    "name": "Arrow down",
    "set": "minor",
    "description": "Used to represent a negative trend when looking at analytical information.",
    "keywords": [
      "arrow",
      "down"
    ]
  },
  "ArrowLeftMinor": {
    "id": "ArrowLeftMinor",
    "name": "Arrow left",
    "set": "minor",
    "description": "Used to indicate that merchants will be directed to the previous page.",
    "keywords": [
      "arrow",
      "left",
      "previous"
    ]
  },
  "ArrowRightMinor": {
    "id": "ArrowRightMinor",
    "name": "Arrow right",
    "set": "minor",
    "description": "Used to indicate that merchants will be directed to the next page.",
    "keywords": [
      "arrow",
      "right",
      "next"
    ]
  },
  "ArrowUpMinor": {
    "id": "ArrowUpMinor",
    "name": "Arrow up",
    "set": "minor",
    "description": "Used to represent a positive trend when looking at analytical information.",
    "keywords": [
      "arrow",
      "up"
    ]
  },
  "AttachmentMajor": {
    "id": "AttachmentMajor",
    "name": "Attachment",
    "set": "major",
    "description": "Used to represent an attachment.",
    "keywords": [
      "attachment",
      "paper clip",
      "files"
    ]
  },
  "AutomationMajor": {
    "id": "AutomationMajor",
    "name": "Automation",
    "set": "major",
    "description": "Used to represent automation, or a task that can be automated.",
    "keywords": [
      "automation",
      "cog",
      "automated",
      "gear"
    ]
  },
  "BackspaceMajor": {
    "id": "BackspaceMajor",
    "name": "Backspace",
    "set": "major",
    "description": "Used to represent backspace on a mobile keyboard.",
    "keywords": [
      "backspace",
      "x",
      "delete"
    ]
  },
  "BalanceMajor": {
    "id": "BalanceMajor",
    "name": "Balance",
    "set": "major",
    "description": "The account’s current balance. This amount is comprised of any transaction not yet included in a payout.",
    "keywords": [
      "balance",
      "wallet",
      "money",
      "transaction",
      "payout"
    ]
  },
  "BankMajor": {
    "id": "BankMajor",
    "name": "Bank",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BarcodeMajor": {
    "id": "BarcodeMajor",
    "name": "Barcode",
    "set": "major",
    "description": "Used to represent a barcode.",
    "keywords": [
      "barcode",
      "scanner"
    ]
  },
  "BehaviorMajor": {
    "id": "BehaviorMajor",
    "name": "Behavior",
    "set": "major",
    "description": "Used to represent a user clicking, or interacting with something.",
    "keywords": [
      "click",
      "cursor"
    ]
  },
  "BehaviorMinor": {
    "id": "BehaviorMinor",
    "name": "Behavior",
    "set": "minor",
    "description": "Used to represent a user clicking, or interacting with something.",
    "keywords": [
      "click",
      "cursor"
    ]
  },
  "BillingStatementDollarMajor": {
    "id": "BillingStatementDollarMajor",
    "name": "Billing statement (dollar)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BillingStatementEuroMajor": {
    "id": "BillingStatementEuroMajor",
    "name": "Billing statement (euro)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BillingStatementPoundMajor": {
    "id": "BillingStatementPoundMajor",
    "name": "Billing statement (pound)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BillingStatementRupeeMajor": {
    "id": "BillingStatementRupeeMajor",
    "name": "Billing statement (rupee)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BillingStatementYenMajor": {
    "id": "BillingStatementYenMajor",
    "name": "Billing statement (yen)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BlockMinor": {
    "id": "BlockMinor",
    "name": "Block",
    "set": "minor",
    "description": "Used to represent a content block as a sub-element of a section, page or layout.",
    "keywords": [
      "block",
      "element",
      "item",
      "layout",
      "content"
    ]
  },
  "BlockquoteMajor": {
    "id": "BlockquoteMajor",
    "name": "Blockquote",
    "set": "major",
    "description": "Used to represent a quote.",
    "keywords": [
      "blockquote",
      "testimonials",
      "quote",
      "speech",
      "text",
      "sections",
      "writing",
      "content"
    ]
  },
  "BlogMajor": {
    "id": "BlogMajor",
    "name": "Blog",
    "set": "major",
    "description": "Used to represent a blog post, or something being written.",
    "keywords": [
      "author",
      "blog",
      "pen",
      "pencil"
    ]
  },
  "BugMajor": {
    "id": "BugMajor",
    "name": "Bug",
    "set": "major",
    "description": "Used to represent a bug in code.",
    "keywords": [
      "bug",
      "insect"
    ]
  },
  "ButtonCornerPillMajor": {
    "id": "ButtonCornerPillMajor",
    "name": "Button corner pill",
    "set": "major",
    "description": "Used to represent the corner shape of a button.",
    "keywords": [
      "button radius",
      "button corner",
      "pill",
      "email",
      "editor"
    ]
  },
  "ButtonCornerRoundedMajor": {
    "id": "ButtonCornerRoundedMajor",
    "name": "Button corner rounded",
    "set": "major",
    "description": "Used to represent the corner shape of a button.",
    "keywords": [
      "button radius",
      "button corner",
      "rounded",
      "email",
      "editor"
    ]
  },
  "ButtonCornerSquareMajor": {
    "id": "ButtonCornerSquareMajor",
    "name": "Button corner square",
    "set": "major",
    "description": "Used to represent the corner shape of a button.",
    "keywords": [
      "button radius",
      "button corner",
      "square",
      "email",
      "editor"
    ]
  },
  "ButtonMinor": {
    "id": "ButtonMinor",
    "name": "Button",
    "set": "minor",
    "description": "Used to represent a button block appearing as a sub-element of a section, page or layout.",
    "keywords": [
      "button",
      "press",
      "click",
      "buy button",
      "block"
    ]
  },
  "BuyButtonButtonLayoutMajor": {
    "id": "BuyButtonButtonLayoutMajor",
    "name": "Buy button button layout",
    "set": "major",
    "description": "Used to represent a centered layout for our Buy Button.",
    "keywords": [
      "center",
      "layout"
    ]
  },
  "BuyButtonHorizontalLayoutMajor": {
    "id": "BuyButtonHorizontalLayoutMajor",
    "name": "Buy button horizontal layout",
    "set": "major",
    "description": "Used to represent a horizontal layout for our Buy Button.",
    "keywords": [
      "button",
      "buy button",
      "layout"
    ]
  },
  "BuyButtonMajor": {
    "id": "BuyButtonMajor",
    "name": "Buy button",
    "set": "major",
    "description": "Used to represent our Buy Button.",
    "keywords": [
      "button",
      "buy button",
      "press"
    ]
  },
  "BuyButtonVerticalLayoutMajor": {
    "id": "BuyButtonVerticalLayoutMajor",
    "name": "Buy button vertical layout",
    "set": "major",
    "description": "Used to represent a vertical layout for our Buy Button.",
    "keywords": [
      "button",
      "buy button",
      "layout"
    ]
  },
  "CalendarMajor": {
    "id": "CalendarMajor",
    "name": "Calendar",
    "set": "major",
    "description": "Used to represent a calendar.",
    "keywords": [
      "calendar"
    ]
  },
  "CalendarMinor": {
    "id": "CalendarMinor",
    "name": "Calendar",
    "set": "minor",
    "description": "Used to denote the action of opening a date picker.",
    "keywords": [
      "calendar",
      "date",
      "time",
      "month",
      "year",
      "day"
    ]
  },
  "CalendarTickMajor": {
    "id": "CalendarTickMajor",
    "name": "Calendar tick",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "CalendarTimeMinor": {
    "id": "CalendarTimeMinor",
    "name": "Calendar time",
    "set": "minor",
    "description": "Used to denote the action of opening a date picker with time",
    "keywords": [
      "calendar",
      "date",
      "time",
      "month",
      "year",
      "day"
    ]
  },
  "CameraMajor": {
    "id": "CameraMajor",
    "name": "Camera",
    "set": "major",
    "description": "Used to represent a camera.",
    "keywords": [
      "camera",
      "photo"
    ]
  },
  "CancelMajor": {
    "id": "CancelMajor",
    "name": "Cancel",
    "set": "major",
    "description": "Used to denote the action of cancelling a task or action and to close an overlay modal or bottom sheet.",
    "keywords": [
      "cancel",
      "delete",
      "stop",
      "remove",
      "undo",
      "x",
      "close"
    ]
  },
  "CancelMinor": {
    "id": "CancelMinor",
    "name": "Cancel",
    "set": "minor",
    "description": "Used to denote the action of cancelling a task or action and to close an overlay or view.",
    "keywords": [
      "cancel",
      "stop",
      "undo",
      "remove",
      "x"
    ]
  },
  "CancelSmallMinor": {
    "id": "CancelSmallMinor",
    "name": "Cancel small",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "cancel",
      "stop",
      "undo",
      "remove",
      "x"
    ]
  },
  "CapitalMajor": {
    "id": "CapitalMajor",
    "name": "Capital",
    "set": "major",
    "description": "Used to help direct merchants to the Capital page",
    "keywords": [
      "capital",
      "flower",
      "plant"
    ]
  },
  "CapturePaymentMinor": {
    "id": "CapturePaymentMinor",
    "name": "Capture payment",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "CardReaderChipMajor": {
    "id": "CardReaderChipMajor",
    "name": "Card reader chip",
    "set": "major",
    "description": "Used to represent a card chip reader.",
    "keywords": [
      "credit card",
      "payment"
    ]
  },
  "CardReaderMajor": {
    "id": "CardReaderMajor",
    "name": "Card reader",
    "set": "major",
    "description": "Used to represent the Shopify Tap and Chip reader.",
    "keywords": [
      "chip and swipe",
      "card reader",
      "POS"
    ]
  },
  "CardReaderTapMajor": {
    "id": "CardReaderTapMajor",
    "name": "Card reader tap",
    "set": "major",
    "description": "Used to represent the Shopify Tap and Chip reader.",
    "keywords": [
      "tap and chip",
      "card reader",
      "POS"
    ]
  },
  "CaretDownMinor": {
    "id": "CaretDownMinor",
    "name": "Caret down",
    "set": "minor",
    "description": "Used to denote the action of expanding a section to reveal more content, like a popover or an accordion. Also used to represent sorting order.",
    "keywords": [
      "caret",
      "down",
      "open"
    ]
  },
  "CaretUpMinor": {
    "id": "CaretUpMinor",
    "name": "Caret up",
    "set": "minor",
    "description": "Used to denote the action of contracting a section to hide additional content, like an accordion. Also used to represent sorting order.",
    "keywords": [
      "caret",
      "up",
      "close"
    ]
  },
  "CartDownMajor": {
    "id": "CartDownMajor",
    "name": "Cart down",
    "set": "major",
    "description": "Used to represent saving the contents of a shopping cart.",
    "keywords": [
      "cart",
      "checkout"
    ]
  },
  "CartMajor": {
    "id": "CartMajor",
    "name": "Cart",
    "set": "major",
    "description": "Used to represent a shopping cart.",
    "keywords": [
      "cart",
      "checkout",
      "shopping"
    ]
  },
  "CartUpMajor": {
    "id": "CartUpMajor",
    "name": "Cart up",
    "set": "major",
    "description": "Used to represent retrieving the contents of saved shopping cart.",
    "keywords": [
      "cart",
      "checkout"
    ]
  },
  "CashDollarMajor": {
    "id": "CashDollarMajor",
    "name": "Cash (dollar)",
    "set": "major",
    "description": "Used to represent Dollar currency.",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashDollarMinor": {
    "id": "CashDollarMinor",
    "name": "Cash (dollar)",
    "set": "minor",
    "description": "Used to represent Dollar currency.",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashEuroMajor": {
    "id": "CashEuroMajor",
    "name": "Cash (euro)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashPoundMajor": {
    "id": "CashPoundMajor",
    "name": "Cash (pound)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashRupeeMajor": {
    "id": "CashRupeeMajor",
    "name": "Cash (rupee)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashYenMajor": {
    "id": "CashYenMajor",
    "name": "Cash (yen)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CategoriesMajor": {
    "id": "CategoriesMajor",
    "name": "Categories",
    "set": "major",
    "description": "Used to represent either list of categories or files.",
    "keywords": [
      "categories",
      "files"
    ]
  },
  "ChannelsMajor": {
    "id": "ChannelsMajor",
    "name": "Channels",
    "set": "major",
    "description": "Used to represent channels, or items connected by a common root.",
    "keywords": [
      "channels",
      "connect",
      "connected",
      "path",
      "related"
    ]
  },
  "ChatMajor": {
    "id": "ChatMajor",
    "name": "Chat",
    "set": "major",
    "description": "Used to represent a conversation, or verbal communication.",
    "keywords": [
      "chat",
      "speech bubble",
      "message",
      "talk"
    ]
  },
  "ChecklistAlternateMajor": {
    "id": "ChecklistAlternateMajor",
    "name": "Checklist alternate",
    "set": "major",
    "description": "Used to represent a checklist.",
    "keywords": [
      "checklist",
      "list"
    ]
  },
  "ChecklistMajor": {
    "id": "ChecklistMajor",
    "name": "Checklist",
    "set": "major",
    "description": "Used to represent a completed checklist.",
    "keywords": [
      "checklist",
      "complete"
    ]
  },
  "CheckoutMajor": {
    "id": "CheckoutMajor",
    "name": "Checkout",
    "set": "major",
    "description": "Used to represent a shopping cart.",
    "keywords": [
      "checkout",
      "cart",
      "shopping"
    ]
  },
  "ChevronDownMinor": {
    "id": "ChevronDownMinor",
    "name": "Chevron down",
    "set": "minor",
    "description": "Used to denote the action of expanding a section to reveal more content.",
    "keywords": [
      "chevron",
      "down"
    ]
  },
  "ChevronLeftMinor": {
    "id": "ChevronLeftMinor",
    "name": "Chevron left",
    "set": "minor",
    "description": "Used to indicate that merchants will be directed to their previous location or to navigate to a previous item.",
    "keywords": [
      "chevron",
      "left"
    ]
  },
  "ChevronRightMinor": {
    "id": "ChevronRightMinor",
    "name": "Chevron right",
    "set": "minor",
    "description": "Used to indicate that merchants will be directed to the next item.",
    "keywords": [
      "chevron",
      "right"
    ]
  },
  "ChevronUpMinor": {
    "id": "ChevronUpMinor",
    "name": "Chevron up",
    "set": "minor",
    "description": "Used to denote the action of contracting a section to hide additional content.",
    "keywords": [
      "chevron",
      "up"
    ]
  },
  "CircleAlertMajor": {
    "id": "CircleAlertMajor",
    "name": "Circle alert",
    "set": "major",
    "description": "Used to alert merchants of a warning message.",
    "keywords": [
      "attention",
      "alert",
      "warning",
      "exclamation",
      "bang",
      "circle",
      "round"
    ]
  },
  "CircleCancelMajor": {
    "id": "CircleCancelMajor",
    "name": "Circle cancel",
    "set": "major",
    "description": "Used to represent an action to cancel or remove an item or resource.",
    "keywords": [
      "cancel",
      "delete",
      "stop",
      "remove",
      "x"
    ]
  },
  "CircleCancelMinor": {
    "id": "CircleCancelMinor",
    "name": "Circle cancel",
    "set": "minor",
    "description": "Used to represent an action to cancel or remove an item or resource.",
    "keywords": [
      "cancel",
      "delete",
      "stop",
      "remove",
      "x"
    ]
  },
  "CircleChevronDownMinor": {
    "id": "CircleChevronDownMinor",
    "name": "Circle chevron down",
    "set": "minor",
    "description": "Used to represent a collapsible section, or an action to navigate down.",
    "keywords": [
      "chevron",
      "down",
      "circle",
      "outline"
    ]
  },
  "CircleChevronLeftMinor": {
    "id": "CircleChevronLeftMinor",
    "name": "Circle chevron left",
    "set": "minor",
    "description": "Used to represent an action to navigate back.",
    "keywords": [
      "back",
      "chevron",
      "left",
      "circle",
      "outline"
    ]
  },
  "CircleChevronRightMinor": {
    "id": "CircleChevronRightMinor",
    "name": "Circle chevron right",
    "set": "minor",
    "description": "Used to help direct merchants from a item’s name in a list to the item’s show page.",
    "keywords": [
      "chevron",
      "right",
      "circle",
      "outline"
    ]
  },
  "CircleChevronUpMinor": {
    "id": "CircleChevronUpMinor",
    "name": "Circle chevron up",
    "set": "minor",
    "description": "Used to represent a collapsible section, or an action to navigate up.",
    "keywords": [
      "chevron",
      "up",
      "circle",
      "outline"
    ]
  },
  "CircleDisableMinor": {
    "id": "CircleDisableMinor",
    "name": "Circle disable",
    "set": "minor",
    "description": "Used to denote the action of disabling something, like a discount code.",
    "keywords": [
      "stop",
      "not permitted",
      "not allowed",
      "error",
      "no",
      "circle",
      "round",
      "disabled",
      "barred"
    ]
  },
  "CircleDisabledMajor": {
    "id": "CircleDisabledMajor",
    "name": "Circle disabled",
    "set": "major",
    "description": "Used to represent an item or resource that is disabled, or an action that is not allowed.",
    "keywords": [
      "blocked",
      "disabled"
    ]
  },
  "CircleDotsMajor": {
    "id": "CircleDotsMajor",
    "name": "Circle dots",
    "set": "major",
    "description": "Used to represent an action to reveal a menu, or more options.",
    "keywords": [
      "ellipsis",
      "options",
      "overflow"
    ]
  },
  "CircleDownMajor": {
    "id": "CircleDownMajor",
    "name": "Circle down",
    "set": "major",
    "description": "Used to represent downwards navigation, or that something is below it.",
    "keywords": [
      "arrow",
      "down"
    ]
  },
  "CircleInformationMajor": {
    "id": "CircleInformationMajor",
    "name": "Circle information",
    "set": "major",
    "description": "Used to represent a hint, or draw attention to a piece of information.",
    "keywords": [
      "info",
      "information",
      "hint"
    ]
  },
  "CircleLeftMajor": {
    "id": "CircleLeftMajor",
    "name": "Circle left",
    "set": "major",
    "description": "Used to represent backwards naviagation, or that something is before it.",
    "keywords": [
      "arrow",
      "back"
    ]
  },
  "CircleMinusMajor": {
    "id": "CircleMinusMajor",
    "name": "Circle minus",
    "set": "major",
    "description": "Used to represent an action to remove an item or resource, or decrease the quantity of an item or resource.",
    "keywords": [
      "less",
      "minus",
      "remove"
    ]
  },
  "CircleMinusMinor": {
    "id": "CircleMinusMinor",
    "name": "Circle minus",
    "set": "minor",
    "description": "Used to represent an action to remove an item or resource, or decrease the quantity of an item or resource.",
    "keywords": [
      "less",
      "minus",
      "remove"
    ]
  },
  "CircleMinusOutlineMinor": {
    "id": "CircleMinusOutlineMinor",
    "name": "Circle minus outline",
    "set": "minor",
    "description": "Used to represent an action to remove an item or resource, or decrease the quantity of an item or resource.",
    "keywords": [
      "less",
      "minus",
      "remove"
    ]
  },
  "CirclePlusMajor": {
    "id": "CirclePlusMajor",
    "name": "Circle plus",
    "set": "major",
    "description": "Similar to the plus icons, used to indicate adding something.",
    "keywords": [
      "add",
      "plus",
      "circle",
      "resource"
    ]
  },
  "CirclePlusMinor": {
    "id": "CirclePlusMinor",
    "name": "Circle plus",
    "set": "minor",
    "description": "Used to represent an action to add an item or resource, or increase the quantity of an item or resource.",
    "keywords": [
      "add",
      "more",
      "plus"
    ]
  },
  "CirclePlusOutlineMinor": {
    "id": "CirclePlusOutlineMinor",
    "name": "Circle plus outline",
    "set": "minor",
    "description": "Used to denote the action of adding new content, like adding a new variant option name in the mobile app.",
    "keywords": [
      "plus",
      "circle",
      "outline",
      "+"
    ]
  },
  "CircleRightMajor": {
    "id": "CircleRightMajor",
    "name": "Circle right",
    "set": "major",
    "description": "Used to represent forwards naviagation, or that something is after it.",
    "keywords": [
      "arrow",
      "forward"
    ]
  },
  "CircleTickMajor": {
    "id": "CircleTickMajor",
    "name": "Circle tick",
    "set": "major",
    "description": "Used to represent an action to approve or confirm.",
    "keywords": [
      "good",
      "positive",
      "checkmark",
      "circle",
      "round",
      "approve"
    ]
  },
  "CircleTickMinor": {
    "id": "CircleTickMinor",
    "name": "Circle tick",
    "set": "minor",
    "description": "Used to represent an action to approve or confirm.",
    "keywords": [
      "good",
      "positive",
      "checkmark",
      "circle",
      "round",
      "approve"
    ]
  },
  "CircleTickOutlineMinor": {
    "id": "CircleTickOutlineMinor",
    "name": "Circle tick outline",
    "set": "minor",
    "description": "Used to represent an action to approve or confirm.",
    "keywords": [
      "good",
      "positive",
      "checkmark",
      "circle",
      "round",
      "approve"
    ]
  },
  "CircleUpMajor": {
    "id": "CircleUpMajor",
    "name": "Circle up",
    "set": "major",
    "description": "Used to represent upwards naviagation, or that something is above it.",
    "keywords": [
      "arrow",
      "up"
    ]
  },
  "ClipboardMinor": {
    "id": "ClipboardMinor",
    "name": "Clipboard",
    "set": "minor",
    "description": "Used to represent a clipboard, usually accompanying a copy action.",
    "keywords": [
      "clipboard",
      "copy",
      "copy and paste"
    ]
  },
  "ClockMajor": {
    "id": "ClockMajor",
    "name": "Clock",
    "set": "major",
    "description": "Used to represent a clock, or the time.",
    "keywords": [
      "time",
      "clock",
      "watch",
      "minute",
      "second",
      "hour",
      "stopwatch",
      "circle"
    ]
  },
  "ClockMinor": {
    "id": "ClockMinor",
    "name": "Clock",
    "set": "minor",
    "description": "Used to indicate time.",
    "keywords": [
      "time",
      "clock",
      "watch",
      "minute",
      "second",
      "hour",
      "stopwatch",
      "circle"
    ]
  },
  "CodeMajor": {
    "id": "CodeMajor",
    "name": "Code",
    "set": "major",
    "description": "Used to represent programming.",
    "keywords": [
      "code",
      "block",
      "liquid",
      "script",
      "syntax"
    ]
  },
  "CodeMinor": {
    "id": "CodeMinor",
    "name": "Code",
    "set": "minor",
    "description": "Used to represent programming.",
    "keywords": [
      "code",
      "block",
      "liquid",
      "script",
      "syntax"
    ]
  },
  "CollectionReferenceMinor": {
    "id": "CollectionReferenceMinor",
    "name": "Collection Reference",
    "set": "minor",
    "description": "Used to represent collections referenced on other resources",
    "keywords": [
      "collection",
      "reference",
      "metafields"
    ]
  },
  "CollectionsMajor": {
    "id": "CollectionsMajor",
    "name": "Collections",
    "set": "major",
    "description": "Used to represent a collection of products.",
    "keywords": [
      "collection",
      "tag",
      "tags",
      "swing"
    ]
  },
  "ColorNoneMinor": {
    "id": "ColorNoneMinor",
    "name": "Color none",
    "set": "minor",
    "description": "Used to represent a lack of color, or that a color is not allowed or available.",
    "keywords": [
      "color",
      "drop",
      "droplet",
      "water",
      "strike",
      "line",
      "no",
      "crossed"
    ]
  },
  "ColorsMajor": {
    "id": "ColorsMajor",
    "name": "Colors",
    "set": "major",
    "description": "Used to represent a color swatch, or palette of colors.",
    "keywords": [
      "color",
      "palette",
      "swatch"
    ]
  },
  "Column1Major": {
    "id": "Column1Major",
    "name": "Column 1",
    "set": "major",
    "description": "Used to represent a 1 column layout.",
    "keywords": [
      "single column",
      "column",
      "layout",
      "email"
    ]
  },
  "ColumnWithTextMajor": {
    "id": "ColumnWithTextMajor",
    "name": "Column with text",
    "set": "major",
    "description": "Used to represent a layout option of two columns, each featuring an image and text.",
    "keywords": [
      "paper",
      "page",
      "content",
      "featured",
      "section",
      "columns",
      "text",
      "image",
      "photo",
      "picture",
      "writing",
      "copy"
    ]
  },
  "Columns2Major": {
    "id": "Columns2Major",
    "name": "Columns 2",
    "set": "major",
    "description": "Used to represent a 2 column layout.",
    "keywords": [
      "two columns",
      "column",
      "layout",
      "email"
    ]
  },
  "Columns3Major": {
    "id": "Columns3Major",
    "name": "Columns 3",
    "set": "major",
    "description": "Used to represent a 3 column layout.",
    "keywords": [
      "three columns",
      "column",
      "layout",
      "email"
    ]
  },
  "Columns3Minor": {
    "id": "Columns3Minor",
    "name": "Columns 3",
    "set": "minor",
    "description": "Used to represent a 3 column layout or an action to hide or show columns",
    "keywords": [
      "three columns",
      "column",
      "options",
      "layout"
    ]
  },
  "ComposeMajor": {
    "id": "ComposeMajor",
    "name": "Compose",
    "set": "major",
    "description": "Used to denote the action of composing a new message.",
    "keywords": [
      "compose",
      "message",
      "write",
      "pencil",
      "pen"
    ]
  },
  "ConfettiMajor": {
    "id": "ConfettiMajor",
    "name": "Confetti",
    "set": "major",
    "description": "Used to represent a moment of celebration, or to call attention to something fun or new.",
    "keywords": [
      "celebrate",
      "confetti",
      "tada"
    ]
  },
  "ConnectMinor": {
    "id": "ConnectMinor",
    "name": "Connect",
    "set": "minor",
    "description": "Used to represent a connection between two items or resources.",
    "keywords": [
      "connect",
      "connected",
      "path",
      "join",
      "related"
    ]
  },
  "ContentMinor": {
    "id": "ContentMinor",
    "name": "Content",
    "set": "minor",
    "description": "Used to represent content.",
    "keywords": [
      "content",
      "files",
      "metaobjects"
    ]
  },
  "ConversationMinor": {
    "id": "ConversationMinor",
    "name": "Conversation",
    "set": "minor",
    "description": "Used to give merchants an indication of comments attached to an order.",
    "keywords": [
      "speech",
      "bubble",
      "conversation",
      "talk",
      "chat",
      "comment"
    ]
  },
  "CreditCardCancelMajor": {
    "id": "CreditCardCancelMajor",
    "name": "Credit card cancel",
    "set": "major",
    "description": "Used to represent a cancellation related to a charge",
    "keywords": [
      "card",
      "credit card",
      "payment",
      "credit card cancel"
    ]
  },
  "CreditCardMajor": {
    "id": "CreditCardMajor",
    "name": "Credit card",
    "set": "major",
    "description": "Used to represent a credit card.",
    "keywords": [
      "card",
      "credit card",
      "payment"
    ]
  },
  "CreditCardPercentMajor": {
    "id": "CreditCardPercentMajor",
    "name": "Credit card percent",
    "set": "major",
    "description": "Used to represent a credit card interest.",
    "keywords": [
      "card",
      "credit card",
      "interest",
      "payment"
    ]
  },
  "CreditCardSecureMajor": {
    "id": "CreditCardSecureMajor",
    "name": "Credit card secure",
    "set": "major",
    "description": "Used to represent a secured credit card.",
    "keywords": [
      "card",
      "credit card",
      "payment",
      "secure"
    ]
  },
  "CurrencyConvertMinor": {
    "id": "CurrencyConvertMinor",
    "name": "Currency convert",
    "set": "minor",
    "description": "Used to represent currency conversion.",
    "keywords": [
      "currency",
      "exchange",
      "forex"
    ]
  },
  "CustomerMinusMajor": {
    "id": "CustomerMinusMajor",
    "name": "Customer minus",
    "set": "major",
    "description": "Used to represent removing a customer, or user.",
    "keywords": [
      "remove",
      "user"
    ]
  },
  "CustomerPlusMajor": {
    "id": "CustomerPlusMajor",
    "name": "Customer plus",
    "set": "major",
    "description": "Used to represent adding a customer, or user.",
    "keywords": [
      "add",
      "user"
    ]
  },
  "CustomersMajor": {
    "id": "CustomersMajor",
    "name": "Customers",
    "set": "major",
    "description": "Used to represent a customer, or user.",
    "keywords": [
      "customer",
      "user"
    ]
  },
  "CustomersMinor": {
    "id": "CustomersMinor",
    "name": "Customers",
    "set": "minor",
    "description": "Used to represent a customer, or user.",
    "keywords": [
      "customer",
      "user"
    ]
  },
  "DataDrivenModelMinor": {
    "id": "DataDrivenModelMinor",
    "name": "Data driven attribution model",
    "set": "minor",
    "description": "Used to represent the Data driven marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "data driven"
    ]
  },
  "DataVisualizationMajor": {
    "id": "DataVisualizationMajor",
    "name": "Data visualization",
    "set": "major",
    "description": "Used to represent a presentation or graph.",
    "keywords": [
      "graph",
      "presentation"
    ]
  },
  "DecimalMinor": {
    "id": "DecimalMinor",
    "name": "Decimal",
    "set": "minor",
    "description": "Used to denote a decimal number",
    "keywords": [
      "decimal",
      "number"
    ]
  },
  "DeleteMajor": {
    "id": "DeleteMajor",
    "name": "Delete",
    "set": "major",
    "description": "Used to represent a trash can, or an action to remove or delete an item or resource.",
    "keywords": [
      "delete",
      "remove",
      "trash"
    ]
  },
  "DeleteMinor": {
    "id": "DeleteMinor",
    "name": "Delete",
    "set": "minor",
    "description": "Used to denote a destructive action to delete an item.",
    "keywords": [
      "delete",
      "remove",
      "trash",
      "garbage",
      "get rid of"
    ]
  },
  "DesktopMajor": {
    "id": "DesktopMajor",
    "name": "Desktop",
    "set": "major",
    "description": "Used to represent a large screen or desktop computer.",
    "keywords": [
      "desktop",
      "screen"
    ]
  },
  "DetailedPopUpMajor": {
    "id": "DetailedPopUpMajor",
    "name": "Detailed pop up",
    "set": "major",
    "description": "Used to represent the option to popup the content.",
    "keywords": [
      "popup",
      "window",
      "overlay"
    ]
  },
  "DiamondAlertMajor": {
    "id": "DiamondAlertMajor",
    "name": "Diamond alert",
    "set": "major",
    "description": "Used to alert merchants of a critical error.",
    "keywords": [
      "alert",
      "attention",
      "critical",
      "diamond",
      "error",
      "exclamation",
      "bang"
    ]
  },
  "DiamondAlertMinor": {
    "id": "DiamondAlertMinor",
    "name": "Diamond alert",
    "set": "minor",
    "description": "Used to alert merchants of a critical error.",
    "keywords": [
      "alert",
      "attention",
      "critical",
      "diamond",
      "error",
      "exclamation",
      "bang"
    ]
  },
  "DigitalMediaReceiverMajor": {
    "id": "DigitalMediaReceiverMajor",
    "name": "Digital media receiver",
    "set": "major",
    "description": "Used to represent a digital receiver or wireless network device.",
    "keywords": [
      "receiver",
      "wifi",
      "wireless"
    ]
  },
  "DiscountAutomaticMajor": {
    "id": "DiscountAutomaticMajor",
    "name": "Discount automatic",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "DiscountCodeMajor": {
    "id": "DiscountCodeMajor",
    "name": "Discount code",
    "set": "major",
    "description": "Used to represent a discount code or coupon.",
    "keywords": [
      "coupon",
      "discount"
    ]
  },
  "DiscountsMajor": {
    "id": "DiscountsMajor",
    "name": "Discounts",
    "set": "major",
    "description": "Used to represent a discount.",
    "keywords": [
      "discount"
    ]
  },
  "DiscountsMinor": {
    "id": "DiscountsMinor",
    "name": "Discounts",
    "set": "minor",
    "description": "Used to represent a discount.",
    "keywords": [
      "discount"
    ]
  },
  "DisputeMinor": {
    "id": "DisputeMinor",
    "name": "Dispute",
    "set": "minor",
    "description": "Used to represent a dispute or important conversation or notification.",
    "keywords": [
      "dispute",
      "claim"
    ]
  },
  "DnsSettingsMajor": {
    "id": "DnsSettingsMajor",
    "name": "Dns settings",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "DockFloatingMajor": {
    "id": "DockFloatingMajor",
    "name": "Dock Floating",
    "set": "major",
    "description": "Used to represent a window that is floating in the bottom right of the admin",
    "keywords": [
      "magic",
      "chat",
      "window",
      "floating",
      "layout",
      "right"
    ]
  },
  "DockSideMajor": {
    "id": "DockSideMajor",
    "name": "Dock Side",
    "set": "major",
    "description": "Used to represent a window that is docked to the right side of the admin",
    "keywords": [
      "magic",
      "chat",
      "window",
      "docked",
      "layout",
      "right"
    ]
  },
  "DomainNewMajor": {
    "id": "DomainNewMajor",
    "name": "Domain new",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "DomainRedirectMinor": {
    "id": "DomainRedirectMinor",
    "name": "Domain redirect",
    "set": "minor",
    "description": "Used to represent a redirect domain.",
    "keywords": [
      "domain",
      "redirect"
    ]
  },
  "DomainsMajor": {
    "id": "DomainsMajor",
    "name": "Domains",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "DraftOrdersMajor": {
    "id": "DraftOrdersMajor",
    "name": "Draft orders",
    "set": "major",
    "description": "Used to represent an order that is in a Draft state.",
    "keywords": [
      "draft",
      "order",
      "pending"
    ]
  },
  "DragDropMajor": {
    "id": "DragDropMajor",
    "name": "Drag drop",
    "set": "major",
    "description": "Used to represent drag and drop.",
    "keywords": [
      "drag",
      "drop",
      "files",
      "copy"
    ]
  },
  "DragHandleMinor": {
    "id": "DragHandleMinor",
    "name": "Drag handle",
    "set": "minor",
    "description": "Used to represent drag handles.",
    "keywords": [
      "drag",
      "draggable",
      "grab",
      "reposition"
    ]
  },
  "DropdownMinor": {
    "id": "DropdownMinor",
    "name": "Dropdown",
    "set": "minor",
    "description": "Used to represent there is dropdown content",
    "keywords": [
      "dropdown",
      "select"
    ]
  },
  "DuplicateMinor": {
    "id": "DuplicateMinor",
    "name": "Duplicate",
    "set": "minor",
    "description": "Used to denote the action of duplicating orders, to save as (reports), and to copy content to clipboard like an address.",
    "keywords": [
      "duplicate",
      "copy",
      "make another one",
      "two",
      "duo"
    ]
  },
  "DynamicSourceMajor": {
    "id": "DynamicSourceMajor",
    "name": "Dynamic Source",
    "set": "major",
    "description": "Used to represent a dynamic source",
    "keywords": [
      "dynamic source",
      "data source",
      "dynamic",
      "data",
      "datasource",
      "dynamicsource",
      "db",
      "database"
    ]
  },
  "DynamicSourceMinor": {
    "id": "DynamicSourceMinor",
    "name": "Dynamic Source",
    "set": "minor",
    "description": "Used to represent a dynamic source",
    "keywords": [
      "dynamic source",
      "data source",
      "dynamic",
      "data",
      "datasource",
      "dynamicsource",
      "db",
      "database"
    ]
  },
  "EditMajor": {
    "id": "EditMajor",
    "name": "Edit",
    "set": "major",
    "description": "Used to represent an action to edit an item or resource.",
    "keywords": [
      "edit",
      "pen",
      "pencil",
      "write"
    ]
  },
  "EditMinor": {
    "id": "EditMinor",
    "name": "Edit",
    "set": "minor",
    "description": "Used to represent the action of editing or modifying information.",
    "keywords": [
      "pencil",
      "pen",
      "paper",
      "edit",
      "page",
      "change"
    ]
  },
  "EmailMajor": {
    "id": "EmailMajor",
    "name": "Email",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "email",
      "letter",
      "mail",
      "rectangle",
      "invite"
    ]
  },
  "EmailNewsletterMajor": {
    "id": "EmailNewsletterMajor",
    "name": "Email newsletter",
    "set": "major",
    "description": "Used to represent an opened email or letter.",
    "keywords": [
      "email",
      "letter",
      "opened",
      "read"
    ]
  },
  "EmbedMinor": {
    "id": "EmbedMinor",
    "name": "Embed",
    "set": "minor",
    "description": "Used to represent an object embedded from a web resource.",
    "keywords": [
      "embed",
      "web resource",
      "web",
      "iframe"
    ]
  },
  "EnableSelectionMinor": {
    "id": "EnableSelectionMinor",
    "name": "Enable selection",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "checkmark",
      "select"
    ]
  },
  "EnterMajor": {
    "id": "EnterMajor",
    "name": "Enter",
    "set": "major",
    "description": "Used to represent the action of authenticating, gaining access or log in",
    "keywords": [
      "authenticating",
      "access",
      "log in",
      "enter",
      "sign in"
    ]
  },
  "EnvelopeMajor": {
    "id": "EnvelopeMajor",
    "name": "Envelope",
    "set": "major",
    "description": "Used to represent an envelope that merchants can use to ship orders to their customers.",
    "keywords": [
      "shipping",
      "packaging",
      "envelope"
    ]
  },
  "ExchangeMajor": {
    "id": "ExchangeMajor",
    "name": "Exchange",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ExistingInventoryMajor": {
    "id": "ExistingInventoryMajor",
    "name": "Existing inventory",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ExitMajor": {
    "id": "ExitMajor",
    "name": "Exit",
    "set": "major",
    "description": "Used to denote the action of exiting an app, channel, or workflow.",
    "keywords": [
      "exit",
      "quit",
      "leave",
      "out"
    ]
  },
  "ExploreImagesMajor": {
    "id": "ExploreImagesMajor",
    "name": "Explore Images",
    "set": "major",
    "description": "Used to represent exploring a variety of imagery assets",
    "keywords": [
      "images",
      "media"
    ]
  },
  "ExportMinor": {
    "id": "ExportMinor",
    "name": "Export",
    "set": "minor",
    "description": "Used to denote the action of exporting content.",
    "keywords": [
      "export",
      "take out",
      "resource"
    ]
  },
  "ExtendMajor": {
    "id": "ExtendMajor",
    "name": "Extend",
    "set": "major",
    "description": "Action | Used when a merchant extends or expands text using AI.",
    "keywords": [
      "extend",
      "expand",
      "lengthen"
    ]
  },
  "ExtendMinor": {
    "id": "ExtendMinor",
    "name": "Extend",
    "set": "minor",
    "description": "Action | Used when a merchant extends or expands text using AI.",
    "keywords": [
      "extend",
      "expand",
      "lengthen"
    ]
  },
  "ExternalMinor": {
    "id": "ExternalMinor",
    "name": "External",
    "set": "minor",
    "description": "Used to denote the action of navigating to an external resource.",
    "keywords": [
      "external",
      "outside",
      "not here"
    ]
  },
  "ExternalSmallMinor": {
    "id": "ExternalSmallMinor",
    "name": "External small",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "EyeDropperMinor": {
    "id": "EyeDropperMinor",
    "name": "Color dropper",
    "set": "minor",
    "description": "Used to represent a color picker.",
    "keywords": [
      "color",
      "color picker",
      "eye dropper"
    ]
  },
  "FaviconMajor": {
    "id": "FaviconMajor",
    "name": "Favicon",
    "set": "major",
    "description": "Used to represent a favicon.",
    "keywords": [
      "favicon",
      "ico",
      "icon"
    ]
  },
  "FavoriteMajor": {
    "id": "FavoriteMajor",
    "name": "Favorite",
    "set": "major",
    "description": "Used to represent an action to favorite or save an item or resource.",
    "keywords": [
      "favorite",
      "favourite",
      "save",
      "star",
      "starred"
    ]
  },
  "FeaturedCollectionMajor": {
    "id": "FeaturedCollectionMajor",
    "name": "Featured collection",
    "set": "major",
    "description": "Used to represent a featured or favorite collection.",
    "keywords": [
      "collection",
      "favorite",
      "favourite",
      "featured"
    ]
  },
  "FeaturedContentMajor": {
    "id": "FeaturedContentMajor",
    "name": "Featured content",
    "set": "major",
    "description": "Used to represent a featured or favorite page or content item.",
    "keywords": [
      "favourite",
      "favorite",
      "feature"
    ]
  },
  "FileMinor": {
    "id": "FileMinor",
    "name": "File",
    "set": "minor",
    "description": "Used to denote a file such as images, video, pdfs, etc.",
    "keywords": [
      "file",
      "images",
      "video"
    ]
  },
  "FilterMajor": {
    "id": "FilterMajor",
    "name": "Filter",
    "set": "major",
    "description": "Used to represent an action to filter a list of items or resources.",
    "keywords": [
      "filter",
      "options"
    ]
  },
  "FilterMinor": {
    "id": "FilterMinor",
    "name": "Filter",
    "set": "minor",
    "description": "Used to represent an action to filter a list of items or resources.",
    "keywords": [
      "filter",
      "options"
    ]
  },
  "FinancesMajor": {
    "id": "FinancesMajor",
    "name": "Finances",
    "set": "major",
    "description": "Used to represent the Finances section.",
    "keywords": [
      "balance",
      "billing",
      "finances",
      "money",
      "payout"
    ]
  },
  "FinancesMinor": {
    "id": "FinancesMinor",
    "name": "Finances",
    "set": "minor",
    "description": "Used to represent the Finances section.",
    "keywords": [
      "balance",
      "billing",
      "finances",
      "money",
      "payout"
    ]
  },
  "FirstClickModelMinor": {
    "id": "FirstClickModelMinor",
    "name": "First click attribution model",
    "set": "minor",
    "description": "Used to represent the first click marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "first click"
    ]
  },
  "FirstOrderMajor": {
    "id": "FirstOrderMajor",
    "name": "First order",
    "set": "major",
    "description": "Used to represent a first order.",
    "keywords": [
      "celebrate",
      "first",
      "milestone",
      "order"
    ]
  },
  "FirstVisitMajor": {
    "id": "FirstVisitMajor",
    "name": "First visit",
    "set": "major",
    "description": "Used to represent a first view or visitor.",
    "keywords": [
      "first",
      "view",
      "visitor"
    ]
  },
  "FlagMajor": {
    "id": "FlagMajor",
    "name": "Flag",
    "set": "major",
    "description": "Used to represent a flag.",
    "keywords": [
      "flag"
    ]
  },
  "FlipCameraMajor": {
    "id": "FlipCameraMajor",
    "name": "Flip camera",
    "set": "major",
    "description": "Used to represent an action to flip a mobile phone camera.",
    "keywords": [
      "camera",
      "flip",
      "selfie"
    ]
  },
  "FolderDownMajor": {
    "id": "FolderDownMajor",
    "name": "Folder down",
    "set": "major",
    "description": "Used to represent an action to download a folder.",
    "keywords": [
      "download",
      "folder"
    ]
  },
  "FolderMajor": {
    "id": "FolderMajor",
    "name": "Folder",
    "set": "major",
    "description": "Used to represent a folder.",
    "keywords": [
      "folder"
    ]
  },
  "FolderMinusMajor": {
    "id": "FolderMinusMajor",
    "name": "Folder minus",
    "set": "major",
    "description": "Used to represent an action to remove a folder.",
    "keywords": [
      "folder",
      "minus",
      "remove"
    ]
  },
  "FolderPlusMajor": {
    "id": "FolderPlusMajor",
    "name": "Folder plus",
    "set": "major",
    "description": "Used to represent an action to add a folder.",
    "keywords": [
      "add",
      "folder",
      "plus"
    ]
  },
  "FolderUpMajor": {
    "id": "FolderUpMajor",
    "name": "Folder up",
    "set": "major",
    "description": "Used to represent an action to upload a folder.",
    "keywords": [
      "folder",
      "upload"
    ]
  },
  "FollowUpEmailMajor": {
    "id": "FollowUpEmailMajor",
    "name": "Follow up email",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "FoodMajor": {
    "id": "FoodMajor",
    "name": "Food",
    "set": "major",
    "description": "Used as a navigation item in our emoji picker for the food category.",
    "keywords": [
      "emoji",
      "navigation",
      "coffee",
      "food"
    ]
  },
  "FooterMajor": {
    "id": "FooterMajor",
    "name": "Footer",
    "set": "major",
    "description": "Used to represent the footer section of a component, page or layout.",
    "keywords": [
      "layout",
      "footer",
      "content",
      "dashed",
      "bottom",
      "section"
    ]
  },
  "FormsMajor": {
    "id": "FormsMajor",
    "name": "Forms",
    "set": "major",
    "description": "Used to represent a text input for a form.",
    "keywords": [
      "form",
      "input",
      "text"
    ]
  },
  "FraudProtectMajor": {
    "id": "FraudProtectMajor",
    "name": "Fraud protect",
    "set": "major",
    "description": "Used to represent that an order is protected by Fraud Protect from chargebacks due to fraud.",
    "keywords": [
      "fraud protect",
      "protected",
      "risk",
      "fraud"
    ]
  },
  "FraudProtectMinor": {
    "id": "FraudProtectMinor",
    "name": "Fraud protect",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "FraudProtectPendingMajor": {
    "id": "FraudProtectPendingMajor",
    "name": "Fraud protect pending",
    "set": "major",
    "description": "Used to represent that the Fraud Protect status is pending.",
    "keywords": [
      "fraud protect",
      "pending",
      "chargebacks",
      "risk",
      "fraud"
    ]
  },
  "FraudProtectPendingMinor": {
    "id": "FraudProtectPendingMinor",
    "name": "Fraud protect pending",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "FraudProtectUnprotectedMajor": {
    "id": "FraudProtectUnprotectedMajor",
    "name": "Fraud protect unprotected",
    "set": "major",
    "description": "Used to represent that an order is not protected by Fraud Protect from chargebacks due to fraud.",
    "keywords": [
      "fraud protect",
      "chargebacks",
      "unprotected",
      "not protected",
      "risk",
      "fraud"
    ]
  },
  "FraudProtectUnprotectedMinor": {
    "id": "FraudProtectUnprotectedMinor",
    "name": "Fraud protect unprotected",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "FulfillmentFulfilledMajor": {
    "id": "FulfillmentFulfilledMajor",
    "name": "Fulfillment fulfilled",
    "set": "major",
    "description": "The fulfillment icon is associated with the 'fulfilled' status.",
    "keywords": [
      "fulfillment",
      "fulfilled"
    ]
  },
  "FulfillmentOnHoldMajor": {
    "id": "FulfillmentOnHoldMajor",
    "name": "Fulfillment on hold",
    "set": "major",
    "description": "The fulfillment icon is associated with the 'on hold' status.",
    "keywords": [
      "fulfillment",
      "on hold",
      "on-hold"
    ]
  },
  "GamesConsoleMajor": {
    "id": "GamesConsoleMajor",
    "name": "Games console",
    "set": "major",
    "description": "Used to represent a console controller.",
    "keywords": [
      "console",
      "controller",
      "games"
    ]
  },
  "GiftCardMajor": {
    "id": "GiftCardMajor",
    "name": "Gift card",
    "set": "major",
    "description": "Used to represent a gift card or present.",
    "keywords": [
      "gift",
      "gift card",
      "present"
    ]
  },
  "GiftCardMinor": {
    "id": "GiftCardMinor",
    "name": "Gift card",
    "set": "minor",
    "description": "Used to represent a gift card or present.",
    "keywords": [
      "gift",
      "gift card",
      "present"
    ]
  },
  "GlobeMajor": {
    "id": "GlobeMajor",
    "name": "Globe",
    "set": "major",
    "description": "Used to represent a globe.",
    "keywords": [
      "globe"
    ]
  },
  "GlobeMinor": {
    "id": "GlobeMinor",
    "name": "Globe",
    "set": "minor",
    "description": "Used to represent a globe.",
    "keywords": [
      "globe"
    ]
  },
  "GrammarMajor": {
    "id": "GrammarMajor",
    "name": "Grammar",
    "set": "major",
    "description": "Used to represent correct grammar or a spell check.",
    "keywords": [
      "grammar",
      "spell check",
      "spelling"
    ]
  },
  "HashtagMajor": {
    "id": "HashtagMajor",
    "name": "Hashtag",
    "set": "major",
    "description": "Used to represent a hashtag.",
    "keywords": [
      "pound",
      "#",
      "sharp",
      "num"
    ]
  },
  "HashtagMinor": {
    "id": "HashtagMinor",
    "name": "Hashtag",
    "set": "minor",
    "description": "Used to represent a hashtag.",
    "keywords": [
      "pound",
      "#",
      "sharp",
      "num"
    ]
  },
  "HeaderMajor": {
    "id": "HeaderMajor",
    "name": "Header",
    "set": "major",
    "description": "Used to represent the header section of a component, page or layout.",
    "keywords": [
      "layout",
      "header",
      "content",
      "dashed",
      "section"
    ]
  },
  "HeartMajor": {
    "id": "HeartMajor",
    "name": "Heart",
    "set": "major",
    "description": "Used to represent a heart or an action to love or like something.",
    "keywords": [
      "heart",
      "love"
    ]
  },
  "HideKeyboardMajor": {
    "id": "HideKeyboardMajor",
    "name": "Hide keyboard",
    "set": "major",
    "description": "Used to represent an action to hide the keyboard on a mobile device.",
    "keywords": [
      "hide keyboard",
      "keyboard"
    ]
  },
  "HideMinor": {
    "id": "HideMinor",
    "name": "Hide",
    "set": "minor",
    "description": "Used to represent an action to hide something, or to represent a hidden item or resource.",
    "keywords": [
      "section",
      "conceal",
      "eye",
      "see",
      "show"
    ]
  },
  "HintMajor": {
    "id": "HintMajor",
    "name": "Hint",
    "set": "major",
    "description": "Used to represent a hint or idea.",
    "keywords": [
      "hint",
      "idea",
      "light bulb"
    ]
  },
  "HomeMajor": {
    "id": "HomeMajor",
    "name": "Home",
    "set": "major",
    "description": "Used to help direct merchants back to the admin home page.",
    "keywords": [
      "home page",
      "home",
      "base",
      "main page",
      "start"
    ]
  },
  "HomeMinor": {
    "id": "HomeMinor",
    "name": "Home",
    "set": "minor",
    "description": "Used to help direct merchants back to the admin home page.",
    "keywords": [
      "home page",
      "home",
      "base",
      "main page",
      "start"
    ]
  },
  "HorizontalDotsMinor": {
    "id": "HorizontalDotsMinor",
    "name": "Horizontal dots",
    "set": "minor",
    "description": "Used to represent additional actions in areas where three or more actions are used.",
    "keywords": [
      "menu",
      "ellipsis",
      "three dots",
      "dots",
      "overflow"
    ]
  },
  "IconsMajor": {
    "id": "IconsMajor",
    "name": "Icons",
    "set": "major",
    "description": "Used to represent icons or shapes.",
    "keywords": [
      "icons",
      "shapes"
    ]
  },
  "IdentityCardMajor": {
    "id": "IdentityCardMajor",
    "name": "Identity card",
    "set": "major",
    "description": "Used to represent a personal identification document, such as a driver’s license.",
    "keywords": [
      "document",
      "upload",
      "license",
      "id",
      "identity",
      "card"
    ]
  },
  "IllustrationMajor": {
    "id": "IllustrationMajor",
    "name": "Illustration",
    "set": "major",
    "description": "Used to represent an illustration, painting or brush.",
    "keywords": [
      "brush",
      "illustration",
      "paint"
    ]
  },
  "ImageAltMajor": {
    "id": "ImageAltMajor",
    "name": "Image alt",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ImageAltMinor": {
    "id": "ImageAltMinor",
    "name": "Image alt",
    "set": "minor",
    "description": "Used to represent the alt text attribute used to describe the appearance and function of an image on a page.",
    "keywords": [
      "accessibility",
      "alt text"
    ]
  },
  "ImageMajor": {
    "id": "ImageMajor",
    "name": "Image",
    "set": "major",
    "description": "Used to represent an image or placeholder.",
    "keywords": [
      "image",
      "placeholder"
    ]
  },
  "ImageWithTextMajor": {
    "id": "ImageWithTextMajor",
    "name": "Image with text",
    "set": "major",
    "description": "Used to represent a layout option of a single column, featuring an image and text.",
    "keywords": [
      "image",
      "picture",
      "photo",
      "text",
      "layout",
      "content",
      "section"
    ]
  },
  "ImageWithTextOverlayMajor": {
    "id": "ImageWithTextOverlayMajor",
    "name": "Image with text overlay",
    "set": "major",
    "description": "Used to represent a layout option of text overlaid on an image.",
    "keywords": [
      "image",
      "picture",
      "photo",
      "text",
      "content",
      "overlay",
      "layout",
      "section"
    ]
  },
  "ImagesMajor": {
    "id": "ImagesMajor",
    "name": "Images",
    "set": "major",
    "description": "Used to represent multiple images.",
    "keywords": [
      "images",
      "gallery"
    ]
  },
  "ImportMinor": {
    "id": "ImportMinor",
    "name": "Import",
    "set": "minor",
    "description": "Used to denote the action of importing content.",
    "keywords": [
      "import",
      "external",
      "export",
      "bringin"
    ]
  },
  "ImportStoreMajor": {
    "id": "ImportStoreMajor",
    "name": "Import store",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "InactiveLocationMajor": {
    "id": "InactiveLocationMajor",
    "name": "InactiveLocation",
    "set": "major",
    "description": "Used to represent an inactive location.",
    "keywords": [
      "inactive location",
      "deactivated location",
      "location"
    ]
  },
  "InactiveLocationMinor": {
    "id": "InactiveLocationMinor",
    "name": "InactiveLocation",
    "set": "minor",
    "description": "Used to represent an inactive location.",
    "keywords": [
      "inactive location",
      "deactivated location",
      "location"
    ]
  },
  "IncomingMajor": {
    "id": "IncomingMajor",
    "name": "Incoming",
    "set": "major",
    "description": "Used to represent an incoming item or resource, or importing an item or resource.",
    "keywords": [
      "import",
      "inbox",
      "incoming"
    ]
  },
  "InfoMinor": {
    "id": "InfoMinor",
    "name": "Info",
    "set": "minor",
    "description": "Used to represent a hint, or draw attention to a piece of information.",
    "keywords": [
      "info",
      "information",
      "hint"
    ]
  },
  "InsertDynamicSourceMajor": {
    "id": "InsertDynamicSourceMajor",
    "name": "Insert Dynamic Source",
    "set": "major",
    "description": "Used to represent inserting a dynamic source into an input field that supports multiple dynamic sources",
    "keywords": [
      "dynamic source",
      "data source",
      "dynamic",
      "data",
      "datasource",
      "dynamicsource",
      "dynamic data",
      "add data source",
      "add dynamic source",
      "add",
      "insert",
      "insert data source",
      "insert dynamic source",
      "db",
      "database"
    ]
  },
  "InsertDynamicSourceMinor": {
    "id": "InsertDynamicSourceMinor",
    "name": "Insert Dynamic Source",
    "set": "minor",
    "description": "Used to represent inserting a dynamic source into an input field that supports multiple dynamic sources",
    "keywords": [
      "dynamic source",
      "data source",
      "dynamic",
      "data",
      "datasource",
      "dynamicsource",
      "dynamic data",
      "add data source",
      "add dynamic source",
      "add",
      "insert",
      "insert data source",
      "insert dynamic source",
      "db",
      "database"
    ]
  },
  "InstallMinor": {
    "id": "InstallMinor",
    "name": "Install",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "InventoryMajor": {
    "id": "InventoryMajor",
    "name": "Inventory",
    "set": "major",
    "description": "Used to represent inventory or a warehouse.",
    "keywords": [
      "inventory",
      "warehouse"
    ]
  },
  "InviteMinor": {
    "id": "InviteMinor",
    "name": "Invite",
    "set": "minor",
    "description": "Used to represent an email or letter.",
    "keywords": [
      "email",
      "invite",
      "letter"
    ]
  },
  "IqMajor": {
    "id": "IqMajor",
    "name": "Iq",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "JobsMajor": {
    "id": "JobsMajor",
    "name": "Jobs",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "KeyMajor": {
    "id": "KeyMajor",
    "name": "Key",
    "set": "major",
    "description": "Used to represent a key or security.",
    "keywords": [
      "key",
      "lock",
      "secure",
      "security",
      "unlock"
    ]
  },
  "KeyboardMajor": {
    "id": "KeyboardMajor",
    "name": "Keyboard",
    "set": "major",
    "description": "Used to represent a keyboard or keyboard shortcuts.",
    "keywords": [
      "keyboard",
      "shortcuts"
    ]
  },
  "KeyboardMinor": {
    "id": "KeyboardMinor",
    "name": "Keyboard",
    "set": "minor",
    "description": "Used to represent a keyboard or keyboard shortcuts.",
    "keywords": [
      "keyboard",
      "shortcuts"
    ]
  },
  "LabelPrinterMajor": {
    "id": "LabelPrinterMajor",
    "name": "Label printer",
    "set": "major",
    "description": "Used to represent a label printer (a special printer that prints 4x6 shipping labels on thermal sticker paper).",
    "keywords": [
      "label",
      "printer",
      "4x6",
      "shipping",
      "print",
      "thermal"
    ]
  },
  "LandingPageMajor": {
    "id": "LandingPageMajor",
    "name": "Landing page",
    "set": "major",
    "description": "Used to represent a landing page or adding an item or resource to a page.",
    "keywords": [
      "landing",
      "landing page",
      "incoming"
    ]
  },
  "LanguageMinor": {
    "id": "LanguageMinor",
    "name": "Language",
    "set": "minor",
    "description": "Used to represent internationalization or multiple language options.",
    "keywords": [
      "language",
      "international"
    ]
  },
  "LastClickModelMinor": {
    "id": "LastClickModelMinor",
    "name": "Last click attribution model",
    "set": "minor",
    "description": "Used to represent the last click marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "last click"
    ]
  },
  "LastNonDirectClickModelMinor": {
    "id": "LastNonDirectClickModelMinor",
    "name": "Last non-direct click attribution model",
    "set": "minor",
    "description": "Used to represent the last non-direct click marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "last non-direct click"
    ]
  },
  "LegalMajor": {
    "id": "LegalMajor",
    "name": "Legal",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "legal",
      "page",
      "scroll",
      "paper"
    ]
  },
  "LinearModelMinor": {
    "id": "LinearModelMinor",
    "name": "Linear attribution model",
    "set": "minor",
    "description": "Used to represent the linear marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "linear"
    ]
  },
  "LinkMinor": {
    "id": "LinkMinor",
    "name": "Link",
    "set": "minor",
    "description": "Used to represent a link.",
    "keywords": [
      "chain",
      "link"
    ]
  },
  "ListMajor": {
    "id": "ListMajor",
    "name": "List",
    "set": "major",
    "description": "Used to represent a list of items or resources, or a bulleted list.",
    "keywords": [
      "bulleted list",
      "list",
      "keywords",
      "todo"
    ]
  },
  "ListMinor": {
    "id": "ListMinor",
    "name": "List",
    "set": "minor",
    "description": "Used to represent a list of items or resources, or a bulleted list.",
    "keywords": [
      "bulleted list",
      "list",
      "keywords",
      "todo"
    ]
  },
  "LiveViewMajor": {
    "id": "LiveViewMajor",
    "name": "Live view",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "LocationMajor": {
    "id": "LocationMajor",
    "name": "Location",
    "set": "major",
    "description": "Used to represent a location.",
    "keywords": [
      "location",
      "pin"
    ]
  },
  "LocationsMinor": {
    "id": "LocationsMinor",
    "name": "Locations",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "LockMajor": {
    "id": "LockMajor",
    "name": "Lock",
    "set": "major",
    "description": "Used to represent a lock, a secure item or resource or that an option or setting is currently locked.",
    "keywords": [
      "lock",
      "secure"
    ]
  },
  "LockMinor": {
    "id": "LockMinor",
    "name": "Lock",
    "set": "minor",
    "description": "Used to represent a lock, a secure item or resource or that an option or setting is currently locked.",
    "keywords": [
      "lock",
      "secure"
    ]
  },
  "LogOutMinor": {
    "id": "LogOutMinor",
    "name": "Log out",
    "set": "minor",
    "description": "Used to denote the action of logging out of Shopify.",
    "keywords": [
      "logout",
      "log-out",
      "sign-out",
      "sign-off",
      "signoff",
      "disconnect",
      "exit",
      "quit"
    ]
  },
  "LogoBlockMajor": {
    "id": "LogoBlockMajor",
    "name": "Logo block",
    "set": "major",
    "description": "Used to represent a layout option of one or more logos.",
    "keywords": [
      "logo",
      "list",
      "layout",
      "section",
      "circle",
      "dotted"
    ]
  },
  "MagicMajor": {
    "id": "MagicMajor",
    "name": "Magic",
    "set": "major",
    "description": "Concept     | Used to represent AI-assisted features.",
    "keywords": [
      "Magic",
      "AI",
      "Artificial Intelligence",
      "ML",
      "Machine Learning",
      "Generative",
      "Sparkle",
      "Stars"
    ]
  },
  "MagicMinor": {
    "id": "MagicMinor",
    "name": "Magic",
    "set": "minor",
    "description": "Concept     | Used to represent AI-assisted features.",
    "keywords": [
      "Magic",
      "AI",
      "Artificial Intelligence",
      "ML",
      "Machine Learning",
      "Generative",
      "Sparkle",
      "Stars"
    ]
  },
  "ManagedStoreMajor": {
    "id": "ManagedStoreMajor",
    "name": "Managed store",
    "set": "major",
    "description": "Used to represent a managed or approved store.",
    "keywords": [
      "approved",
      "managed",
      "store"
    ]
  },
  "MarkFulfilledMinor": {
    "id": "MarkFulfilledMinor",
    "name": "Mark fulfilled",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarkPaidMinor": {
    "id": "MarkPaidMinor",
    "name": "Mark paid",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketingMajor": {
    "id": "MarketingMajor",
    "name": "Marketing",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketingMinor": {
    "id": "MarketingMinor",
    "name": "Marketing",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketsMajor": {
    "id": "MarketsMajor",
    "name": "Markets",
    "set": "major",
    "description": "Used to represent Markets, Shopify’s international commerce product.",
    "keywords": [
      "markets",
      "international",
      "commerce",
      "global"
    ]
  },
  "MaximizeMajor": {
    "id": "MaximizeMajor",
    "name": "Maximize",
    "set": "major",
    "description": "Used to represent an action to make an item, resource or view larger.",
    "keywords": [
      "expand",
      "full screen",
      "maximise"
    ]
  },
  "MaximizeMinor": {
    "id": "MaximizeMinor",
    "name": "Maximize",
    "set": "minor",
    "description": "Used to represent an action to make an item, resource or view larger.",
    "keywords": [
      "expand",
      "full screen",
      "maximise"
    ]
  },
  "MeasurementMinor": {
    "id": "MeasurementMinor",
    "name": "Measurement",
    "set": "minor",
    "description": "Used to represent measurement including dimension, volume, and weight.",
    "keywords": [
      "dimension",
      "weight",
      "volume",
      "measurement",
      "size"
    ]
  },
  "MentionMajor": {
    "id": "MentionMajor",
    "name": "Mention",
    "set": "major",
    "description": "Used to represent an action to mention someone.",
    "keywords": [
      "at",
      "mention"
    ]
  },
  "MergeMinor": {
    "id": "MergeMinor",
    "name": "Merge",
    "set": "minor",
    "description": "Used to represent merging of objects.",
    "keywords": [
      "merge",
      "combine",
      "union",
      "join"
    ]
  },
  "MetafieldsMajor": {
    "id": "MetafieldsMajor",
    "name": "Metafields",
    "set": "major",
    "description": "Used to represent metafields",
    "keywords": [
      "metafields",
      "data sources"
    ]
  },
  "MetafieldsMinor": {
    "id": "MetafieldsMinor",
    "name": "Metafields",
    "set": "minor",
    "description": "Used to represent metafields",
    "keywords": [
      "metafields",
      "data sources"
    ]
  },
  "MetaobjectMinor": {
    "id": "MetaobjectMinor",
    "name": "Metaobject",
    "set": "minor",
    "description": "Used to represent metaobjects",
    "keywords": [
      "metaobject",
      "content"
    ]
  },
  "MetaobjectReferenceMinor": {
    "id": "MetaobjectReferenceMinor",
    "name": "Metaobject Reference",
    "set": "minor",
    "description": "Used to represent a metaobject referenced on other resources",
    "keywords": [
      "metaobject",
      "reference"
    ]
  },
  "MicrophoneMajor": {
    "id": "MicrophoneMajor",
    "name": "Microphone",
    "set": "major",
    "description": "Used to represent a microphone.",
    "keywords": [
      "mic",
      "microphone"
    ]
  },
  "MinimizeMajor": {
    "id": "MinimizeMajor",
    "name": "Minimize",
    "set": "major",
    "description": "Used to represent an action to make an item, resource or view smaller.",
    "keywords": [
      "minimise"
    ]
  },
  "MinimizeMinor": {
    "id": "MinimizeMinor",
    "name": "Minimize",
    "set": "minor",
    "description": "Used to represent an action to make an item, resource or view smaller.",
    "keywords": [
      "minimise"
    ]
  },
  "MinusMajor": {
    "id": "MinusMajor",
    "name": "Minus",
    "set": "major",
    "description": "Used to denote the action of removing an item.",
    "keywords": [
      "minus",
      "negative",
      "subtract",
      "subtraction",
      "math",
      "-",
      "substract",
      "less"
    ]
  },
  "MinusMinor": {
    "id": "MinusMinor",
    "name": "Minus",
    "set": "minor",
    "description": "Used to denote the action of removing an item.",
    "keywords": [
      "minus",
      "negative",
      "subtract",
      "subtraction",
      "math",
      "-",
      "substract",
      "less"
    ]
  },
  "MobileAcceptMajor": {
    "id": "MobileAcceptMajor",
    "name": "Mobile accept",
    "set": "major",
    "description": "Used to represent a confirm action. Most commonly used in the toolbar in an _edit_ context.",
    "keywords": [
      "accept",
      "save",
      "confirm",
      "check"
    ]
  },
  "MobileBackArrowMajor": {
    "id": "MobileBackArrowMajor",
    "name": "Mobile back arrow",
    "set": "major",
    "description": "Used to represent backwards navigation.",
    "keywords": [
      "back",
      "navigation"
    ]
  },
  "MobileCancelMajor": {
    "id": "MobileCancelMajor",
    "name": "Mobile cancel",
    "set": "major",
    "description": "Used to denote the action of cancelling a task or action and to close an overlay modal or bottom sheet.",
    "keywords": [
      "cancel",
      "delete",
      "stop",
      "remove",
      "undo",
      "x",
      "close"
    ]
  },
  "MobileChevronMajor": {
    "id": "MobileChevronMajor",
    "name": "Mobile chevron",
    "set": "major",
    "description": "Used to represent the back action commonly found in iOS.",
    "keywords": [
      "back",
      "ios",
      "navigation"
    ]
  },
  "MobileHamburgerMajor": {
    "id": "MobileHamburgerMajor",
    "name": "Mobile hamburger",
    "set": "major",
    "description": "Used to help direct merchants to navigation on mobile.",
    "keywords": [
      "hamburger",
      "menu",
      "burger"
    ]
  },
  "MobileHorizontalDotsMajor": {
    "id": "MobileHorizontalDotsMajor",
    "name": "Mobile horizontal dots",
    "set": "major",
    "description": "Used to represent an action to reveal a menu or more options.",
    "keywords": [
      "dots",
      "ellipsis",
      "menu",
      "options",
      "overflow",
      "..."
    ]
  },
  "MobileMajor": {
    "id": "MobileMajor",
    "name": "Mobile",
    "set": "major",
    "description": "Used to represent a mobile phone.",
    "keywords": [
      "mobile",
      "phone"
    ]
  },
  "MobilePlusMajor": {
    "id": "MobilePlusMajor",
    "name": "Mobile plus",
    "set": "major",
    "description": "Used to represent an action to add an item or resource, or increase the quantity of an item or resource.",
    "keywords": [
      "add",
      "plus",
      "increase"
    ]
  },
  "MobileVerticalDotsMajor": {
    "id": "MobileVerticalDotsMajor",
    "name": "Mobile vertical dots",
    "set": "major",
    "description": "Used to represent an action to reveal a menu or more options.",
    "keywords": [
      "dots",
      "menu",
      "options",
      "overflow"
    ]
  },
  "MonerisMajor": {
    "id": "MonerisMajor",
    "name": "Moneris",
    "set": "major",
    "description": "Used to represent a handheld credit card reader.",
    "keywords": [
      "credit card",
      "moneris",
      "payment"
    ]
  },
  "MoneyMinor": {
    "id": "MoneyMinor",
    "name": "Money",
    "set": "minor",
    "description": "Used to represent money.",
    "keywords": [
      "money",
      "balance",
      "billing",
      "finances",
      "money",
      "payout",
      "cash"
    ]
  },
  "NatureMajor": {
    "id": "NatureMajor",
    "name": "Nature",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "NavigationMajor": {
    "id": "NavigationMajor",
    "name": "Navigation",
    "set": "major",
    "description": "Used to represent a compass or navigation.",
    "keywords": [
      "compass",
      "navigation"
    ]
  },
  "NoteMajor": {
    "id": "NoteMajor",
    "name": "Note",
    "set": "major",
    "description": "Used to represent a document or note.",
    "keywords": [
      "annotations",
      "document",
      "note",
      "notes",
      "page",
      "paper",
      "tags"
    ]
  },
  "NoteMinor": {
    "id": "NoteMinor",
    "name": "Note",
    "set": "minor",
    "description": "Used to represent a document or note.",
    "keywords": [
      "annotations",
      "document",
      "note",
      "notes",
      "page",
      "paper",
      "tags"
    ]
  },
  "NotificationMajor": {
    "id": "NotificationMajor",
    "name": "Notification",
    "set": "major",
    "description": "Used to represent a notification or alert.",
    "keywords": [
      "notifications",
      "alerts",
      "bell"
    ]
  },
  "OnlineStoreMajor": {
    "id": "OnlineStoreMajor",
    "name": "Online store",
    "set": "major",
    "description": "Used to represent an online store.",
    "keywords": [
      "online store",
      "store"
    ]
  },
  "OnlineStoreMinor": {
    "id": "OnlineStoreMinor",
    "name": "Online store",
    "set": "minor",
    "description": "Used to represent an online store.",
    "keywords": [
      "online store",
      "store"
    ]
  },
  "OrderStatusMinor": {
    "id": "OrderStatusMinor",
    "name": "Order status",
    "set": "minor",
    "description": "Used to represent the activity of an inbox.",
    "keywords": [
      "activity",
      "inbox",
      "status",
      "orders"
    ]
  },
  "OrdersMajor": {
    "id": "OrdersMajor",
    "name": "Orders",
    "set": "major",
    "description": "Used to represent an inbox or an item or resource arriving in an inbox.",
    "keywords": [
      "inbox",
      "orders"
    ]
  },
  "OrdersMinor": {
    "id": "OrdersMinor",
    "name": "Orders",
    "set": "minor",
    "description": "Used to represent an inbox or an item or resource arriving in an inbox.",
    "keywords": [
      "inbox",
      "orders"
    ]
  },
  "OrganizationMajor": {
    "id": "OrganizationMajor",
    "name": "Organization",
    "set": "major",
    "description": "Used to represent a plus organization.",
    "keywords": [
      "organization",
      "business"
    ]
  },
  "OutgoingMajor": {
    "id": "OutgoingMajor",
    "name": "Outgoing",
    "set": "major",
    "description": "Used to represent an outgoing item or resource, or exporting an item or resource.",
    "keywords": [
      "export",
      "outbox",
      "outgoing"
    ]
  },
  "PackageMajor": {
    "id": "PackageMajor",
    "name": "Package",
    "set": "major",
    "description": "Used to represent a package or box that merchants can ship their products in.",
    "keywords": [
      "shipping",
      "box",
      "package",
      "cardboard"
    ]
  },
  "PageDownMajor": {
    "id": "PageDownMajor",
    "name": "Page down",
    "set": "major",
    "description": "Used to represent an action to download a page or document.",
    "keywords": [
      "document",
      "download",
      "page",
      "paper"
    ]
  },
  "PageMajor": {
    "id": "PageMajor",
    "name": "Page",
    "set": "major",
    "description": "Used to represent a blank page or document.",
    "keywords": [
      "blank",
      "document",
      "page",
      "paper"
    ]
  },
  "PageMinusMajor": {
    "id": "PageMinusMajor",
    "name": "Page minus",
    "set": "major",
    "description": "Used to represent an action to remove a page or document.",
    "keywords": [
      "document",
      "minus",
      "page",
      "paper",
      "remove"
    ]
  },
  "PagePlusMajor": {
    "id": "PagePlusMajor",
    "name": "Page plus",
    "set": "major",
    "description": "Used to represent an action to add a page or document.",
    "keywords": [
      "add",
      "document",
      "page",
      "paper"
    ]
  },
  "PageReferenceMinor": {
    "id": "PageReferenceMinor",
    "name": "Page Reference",
    "set": "minor",
    "description": "Used to represent pages referenced on other resources",
    "keywords": [
      "page",
      "reference",
      "metafields"
    ]
  },
  "PageUpMajor": {
    "id": "PageUpMajor",
    "name": "Page up",
    "set": "major",
    "description": "Used to represent an action to upload a page or document.",
    "keywords": [
      "document",
      "page",
      "paper",
      "upload"
    ]
  },
  "PaginationEndMinor": {
    "id": "PaginationEndMinor",
    "name": "Pagination end",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaginationStartMinor": {
    "id": "PaginationStartMinor",
    "name": "Pagination start",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaintBrushMajor": {
    "id": "PaintBrushMajor",
    "name": "Paint brush",
    "set": "major",
    "description": "Used to represent a paintbrush or an action to customize an item or resource.",
    "keywords": [
      "brush",
      "customize",
      "paintbrush"
    ]
  },
  "PaperCheckMajor": {
    "id": "PaperCheckMajor",
    "name": "PaperCheck",
    "set": "major",
    "description": "Used to represent a paper check payment method.",
    "keywords": [
      "payment method"
    ]
  },
  "PaperCheckMinor": {
    "id": "PaperCheckMinor",
    "name": "PaperCheck",
    "set": "minor",
    "description": "Used to represent a paper check payment method.",
    "keywords": [
      "payment method"
    ]
  },
  "PasskeyMajor": {
    "id": "PasskeyMajor",
    "name": "Passkey",
    "set": "major",
    "description": "Used to represent a passkey",
    "keywords": [
      "passkey",
      "identity",
      "security"
    ]
  },
  "PasskeyMinor": {
    "id": "PasskeyMinor",
    "name": "Passkey",
    "set": "minor",
    "description": "Used to represent a passkey",
    "keywords": [
      "passkey",
      "identity",
      "security"
    ]
  },
  "PauseCircleMajor": {
    "id": "PauseCircleMajor",
    "name": "Pause circle",
    "set": "major",
    "description": "Used to represent an action to pause something.",
    "keywords": [
      "pause",
      "media",
      "video",
      "motion",
      "animation",
      "film"
    ]
  },
  "PauseMajor": {
    "id": "PauseMajor",
    "name": "Pause",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PauseMinor": {
    "id": "PauseMinor",
    "name": "Pause",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaymentsMajor": {
    "id": "PaymentsMajor",
    "name": "Payments",
    "set": "major",
    "description": "Used to represent a payment made by credit or debit card.",
    "keywords": [
      "credit",
      "credit card",
      "debit",
      "debit card",
      "payment"
    ]
  },
  "PersonalizedTextMajor": {
    "id": "PersonalizedTextMajor",
    "name": "Personalized text",
    "set": "major",
    "description": "Used to represent personalized text features.",
    "keywords": [
      "Personalized text",
      "Personalization",
      "Customer attributes",
      "Customer",
      "Dynamic content"
    ]
  },
  "PhoneInMajor": {
    "id": "PhoneInMajor",
    "name": "Phone in",
    "set": "major",
    "description": "Used to represent an incoming phone call.",
    "keywords": [
      "call",
      "incoming",
      "phone"
    ]
  },
  "PhoneMajor": {
    "id": "PhoneMajor",
    "name": "Phone",
    "set": "major",
    "description": "Used to represent a phone or phone call.",
    "keywords": [
      "call",
      "phone"
    ]
  },
  "PhoneOutMajor": {
    "id": "PhoneOutMajor",
    "name": "Phone out",
    "set": "major",
    "description": "Used to represent an outgoing phone call.",
    "keywords": [
      "call",
      "outgoing",
      "phone"
    ]
  },
  "PinMajor": {
    "id": "PinMajor",
    "name": "Pin",
    "set": "major",
    "description": "Used to represent a pin or an action to pin or save something.",
    "keywords": [
      "pin",
      "save"
    ]
  },
  "PinMinor": {
    "id": "PinMinor",
    "name": "Pin",
    "set": "minor",
    "description": "Used to represent a pin or an action to pin or save something.",
    "keywords": [
      "pin",
      "save"
    ]
  },
  "PinUnfilledMajor": {
    "id": "PinUnfilledMajor",
    "name": "Pin Unfilled",
    "set": "major",
    "description": "Used to represent an unpinned item or an action to unpin something.",
    "keywords": [
      "unpin"
    ]
  },
  "PinUnfilledMinor": {
    "id": "PinUnfilledMinor",
    "name": "Pin Unfilled",
    "set": "minor",
    "description": "Used to represent an unpinned item or an action to unpin something.",
    "keywords": [
      "unpin"
    ]
  },
  "PlanMajor": {
    "id": "PlanMajor",
    "name": "Plans",
    "set": "major",
    "description": "Wayfinding | Used to help direct merchants to the Plan page in Settings.",
    "keywords": [
      "Plan",
      "Plans",
      "Steps",
      "Levels",
      "Stairs",
      "Staircase"
    ]
  },
  "PlanMinor": {
    "id": "PlanMinor",
    "name": "Plans",
    "set": "minor",
    "description": "Wayfinding | Minor icon used to help direct merchants to the Plan page in Settings.",
    "keywords": [
      "Plan",
      "Plans",
      "Steps",
      "Levels",
      "Stairs",
      "Staircase"
    ]
  },
  "PlayCircleMajor": {
    "id": "PlayCircleMajor",
    "name": "Play circle",
    "set": "major",
    "description": "Used to represent an action to play or resume something.",
    "keywords": [
      "video",
      "control",
      "media",
      "play",
      "motion",
      "animation",
      "film",
      "circle"
    ]
  },
  "PlayMajor": {
    "id": "PlayMajor",
    "name": "Play",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PlayMinor": {
    "id": "PlayMinor",
    "name": "Play",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PlusMinor": {
    "id": "PlusMinor",
    "name": "Plus",
    "set": "minor",
    "description": "Used to denote the action of adding an item and zooming into a map.",
    "keywords": [
      "plus",
      "addition",
      "add",
      "math"
    ]
  },
  "PointOfSaleMajor": {
    "id": "PointOfSaleMajor",
    "name": "Point of sale",
    "set": "major",
    "description": "Used to represent a point of sale or sales register.",
    "keywords": [
      "point of sale",
      "POS",
      "terminal",
      "register"
    ]
  },
  "PopularMajor": {
    "id": "PopularMajor",
    "name": "Popular",
    "set": "major",
    "description": "Used to represent activity or something increasing in popularity.",
    "keywords": [
      "activity",
      "graph",
      "popular"
    ]
  },
  "PositionBasedModelMinor": {
    "id": "PositionBasedModelMinor",
    "name": "Position based attribution model",
    "set": "minor",
    "description": "Used to represent the position based marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "position based"
    ]
  },
  "PriceLookupMinor": {
    "id": "PriceLookupMinor",
    "name": "Price lookup",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PrintMajor": {
    "id": "PrintMajor",
    "name": "Print",
    "set": "major",
    "description": "Used to represent a printer or an action to print something.",
    "keywords": [
      "desktop",
      "label",
      "printer"
    ]
  },
  "PrintMinor": {
    "id": "PrintMinor",
    "name": "Print",
    "set": "minor",
    "description": "Used to denote the action of printing.",
    "keywords": [
      "print",
      "printing",
      "printer"
    ]
  },
  "ProductCostMajor": {
    "id": "ProductCostMajor",
    "name": "ProductCostMajor",
    "set": "major",
    "description": "Used to represent the cost of a product",
    "keywords": [
      "product",
      "cost"
    ]
  },
  "ProductReferenceMinor": {
    "id": "ProductReferenceMinor",
    "name": "Product Reference",
    "set": "minor",
    "description": "Used to represent products referenced on other resources",
    "keywords": [
      "products",
      "reference",
      "metafields"
    ]
  },
  "ProductReturnsMinor": {
    "id": "ProductReturnsMinor",
    "name": "Product returns",
    "set": "minor",
    "description": "Used to help direct merchants to returns page.",
    "keywords": [
      "return",
      "product return",
      "return page",
      "arrow"
    ]
  },
  "ProductsMajor": {
    "id": "ProductsMajor",
    "name": "Products",
    "set": "major",
    "description": "Used to represent products or a price tag.",
    "keywords": [
      "tag",
      "products",
      "price"
    ]
  },
  "ProductsMinor": {
    "id": "ProductsMinor",
    "name": "Products",
    "set": "minor",
    "description": "Used to represent products or a price tag.",
    "keywords": [
      "tag",
      "products",
      "price"
    ]
  },
  "ProfileMajor": {
    "id": "ProfileMajor",
    "name": "Profile",
    "set": "major",
    "description": "Used to represent a staff member.",
    "keywords": [
      "avatar",
      "user",
      "profile",
      "me",
      "portrait",
      "staff"
    ]
  },
  "ProfileMinor": {
    "id": "ProfileMinor",
    "name": "Profile",
    "set": "minor",
    "description": "Used to represent a staff member.",
    "keywords": [
      "avatar",
      "user",
      "profile",
      "me",
      "portrait",
      "staff"
    ]
  },
  "PromoteMinor": {
    "id": "PromoteMinor",
    "name": "Promote",
    "set": "minor",
    "description": "Used to represent an action to open an external resource, or promote an item or resource.",
    "keywords": [
      "external",
      "promote"
    ]
  },
  "QuestionMarkInverseMajor": {
    "id": "QuestionMarkInverseMajor",
    "name": "Question mark inverse",
    "set": "major",
    "description": "Used to give merchants help or support for a feature.",
    "keywords": [
      "question",
      "question mark",
      "help",
      "support",
      "learn more",
      "circle"
    ]
  },
  "QuestionMarkInverseMinor": {
    "id": "QuestionMarkInverseMinor",
    "name": "Question mark inverse",
    "set": "minor",
    "description": "Used to give merchants help or support for a feature.",
    "keywords": [
      "question",
      "question mark",
      "help",
      "support",
      "learn more",
      "circle"
    ]
  },
  "QuestionMarkMajor": {
    "id": "QuestionMarkMajor",
    "name": "Question mark",
    "set": "major",
    "description": "Used to give merchants help or support for a feature.",
    "keywords": [
      "question",
      "question mark",
      "help",
      "support",
      "learn more",
      "circle"
    ]
  },
  "QuestionMarkMinor": {
    "id": "QuestionMarkMinor",
    "name": "Question mark",
    "set": "minor",
    "description": "Used to represent help, information or as an action to reveal more information about an item or resource.",
    "keywords": [
      "help",
      "hint",
      "info",
      "question"
    ]
  },
  "QuickSaleMajor": {
    "id": "QuickSaleMajor",
    "name": "Quick sale",
    "set": "major",
    "description": "Used to represent a quick checkout process or quick sale.",
    "keywords": [
      "cart",
      "checkout",
      "quick",
      "sale"
    ]
  },
  "ReadTimeMinor": {
    "id": "ReadTimeMinor",
    "name": "Read time",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReceiptMajor": {
    "id": "ReceiptMajor",
    "name": "Receipt",
    "set": "major",
    "description": "Used to represent a sales receipt or invoice.",
    "keywords": [
      "invoice",
      "receipt",
      "sale"
    ]
  },
  "RecentSearchesMajor": {
    "id": "RecentSearchesMajor",
    "name": "Recent searches",
    "set": "major",
    "description": "Used to represent recent searches or search history.",
    "keywords": [
      "history",
      "recent",
      "recent search",
      "search history"
    ]
  },
  "RedoMajor": {
    "id": "RedoMajor",
    "name": "Redo",
    "set": "major",
    "description": "Used to indicate redoing an action after undoing it.",
    "keywords": [
      "redo",
      "undo",
      "rollback",
      "return"
    ]
  },
  "ReferralCodeMajor": {
    "id": "ReferralCodeMajor",
    "name": "Referral code",
    "set": "major",
    "description": "Used to represent a referral code’s usage status.",
    "keywords": [
      "referral",
      "code",
      "coupon"
    ]
  },
  "ReferralMajor": {
    "id": "ReferralMajor",
    "name": "Referral",
    "set": "major",
    "description": "Used to represent the source of a referral.",
    "keywords": [
      "referral",
      "code",
      "coupon"
    ]
  },
  "RefreshMajor": {
    "id": "RefreshMajor",
    "name": "Refresh",
    "set": "major",
    "description": "Used to represent an action to refresh or sync an item or resource.",
    "keywords": [
      "refresh",
      "reload",
      "sync"
    ]
  },
  "RefreshMinor": {
    "id": "RefreshMinor",
    "name": "Refresh",
    "set": "minor",
    "description": "Used to denote the action of resetting a customer’s account password on their customer page.",
    "keywords": [
      "refresh",
      "reload",
      "sync"
    ]
  },
  "RefundMajor": {
    "id": "RefundMajor",
    "name": "Refund",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "RefundMinor": {
    "id": "RefundMinor",
    "name": "Refund",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "RemoveProductMajor": {
    "id": "RemoveProductMajor",
    "name": "Remove product",
    "set": "major",
    "description": "Used to represent an action to remove a product.",
    "keywords": [
      "remove",
      "minus",
      "product"
    ]
  },
  "RepeatOrderMajor": {
    "id": "RepeatOrderMajor",
    "name": "Repeat order",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReplaceMajor": {
    "id": "ReplaceMajor",
    "name": "Replace",
    "set": "major",
    "description": "Used to represent an action to replace an item or resource with another.",
    "keywords": [
      "replace",
      "image",
      "picture",
      "photo",
      "switch",
      "swap",
      "arrow",
      "arrows",
      "square"
    ]
  },
  "ReplayMinor": {
    "id": "ReplayMinor",
    "name": "Replay",
    "set": "minor",
    "description": "Used to represent an action to replay or restart something.",
    "keywords": [
      "replay",
      "restart"
    ]
  },
  "ReportMinor": {
    "id": "ReportMinor",
    "name": "Report",
    "set": "minor",
    "description": "Used to represent analytics or a report.",
    "keywords": [
      "analytics",
      "report",
      "reporting"
    ]
  },
  "ReportsMajor": {
    "id": "ReportsMajor",
    "name": "Reports",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ResetMinor": {
    "id": "ResetMinor",
    "name": "Reset",
    "set": "minor",
    "description": "Used to represent an action to reset or restart something.",
    "keywords": [
      "reset",
      "restart"
    ]
  },
  "ResourcesMajor": {
    "id": "ResourcesMajor",
    "name": "Resources",
    "set": "major",
    "description": "Used to represent resources to learn more about a topic or feature.",
    "keywords": [
      "resources",
      "learn more",
      "glasses",
      "research"
    ]
  },
  "ReturnMinor": {
    "id": "ReturnMinor",
    "name": "Return",
    "set": "minor",
    "description": "Used to represent an action to create a new line, sometimes referred to as a carriage return.",
    "keywords": [
      "enter",
      "return"
    ]
  },
  "ReturnsMajor": {
    "id": "ReturnsMajor",
    "name": "Returns",
    "set": "major",
    "description": "Used to represent returns on an order.",
    "keywords": [
      "returns",
      "return",
      "order"
    ]
  },
  "RichTextMinor": {
    "id": "RichTextMinor",
    "name": "Rich text",
    "set": "minor",
    "description": "Used to denote rich text",
    "keywords": [
      "rich text",
      "RTE",
      "rich text editor"
    ]
  },
  "RiskMajor": {
    "id": "RiskMajor",
    "name": "Risk",
    "set": "major",
    "description": "Used to represent elevated risk on a payment or order, usually the risk of credit card fraud.",
    "keywords": [
      "risk",
      "fraud"
    ]
  },
  "RiskMinor": {
    "id": "RiskMinor",
    "name": "Risk",
    "set": "minor",
    "description": "Used to represent risk associated with orders.",
    "keywords": [
      "risk",
      "warning",
      "triangle",
      "alert"
    ]
  },
  "Rows2Major": {
    "id": "Rows2Major",
    "name": "Rows 2",
    "set": "major",
    "description": "Used to represent a 2 row layout.",
    "keywords": [
      "two rows",
      "row",
      "layout"
    ]
  },
  "SandboxMajor": {
    "id": "SandboxMajor",
    "name": "Sandbox",
    "set": "major",
    "description": "Used to represent a development store (feature exclusive to Shopify Plus Partners).",
    "keywords": [
      "sandbox",
      "plus",
      "partners",
      "partner",
      "development",
      "testing"
    ]
  },
  "SaveMinor": {
    "id": "SaveMinor",
    "name": "Save",
    "set": "minor",
    "description": "Used to denote the action of saving.",
    "keywords": [
      "save",
      "saving",
      "store"
    ]
  },
  "SearchMajor": {
    "id": "SearchMajor",
    "name": "Search",
    "set": "major",
    "description": "Used to represent search or an action to search for an item or resource.",
    "keywords": [
      "find",
      "look up",
      "magnifying glass",
      "search"
    ]
  },
  "SearchMinor": {
    "id": "SearchMinor",
    "name": "Search",
    "set": "minor",
    "description": "Used to denote the action of searching throughout the admin.",
    "keywords": [
      "search",
      "find",
      "glass"
    ]
  },
  "SectionMajor": {
    "id": "SectionMajor",
    "name": "Section",
    "set": "major",
    "description": "Used to represent the middle section of a component, page or layout.",
    "keywords": [
      "layout",
      "middle",
      "content",
      "dashed",
      "section"
    ]
  },
  "SecureMajor": {
    "id": "SecureMajor",
    "name": "Secure",
    "set": "major",
    "description": "Used to represent a secure or protected item or resource, or than an item or resource can be trusted.",
    "keywords": [
      "protected",
      "secure",
      "trust",
      "verified"
    ]
  },
  "SelectMinor": {
    "id": "SelectMinor",
    "name": "Select",
    "set": "minor",
    "description": "Used to denote the action opening a select.",
    "keywords": [
      "caret",
      "arrow",
      "up",
      "down",
      "select",
      "open"
    ]
  },
  "SendMajor": {
    "id": "SendMajor",
    "name": "Send",
    "set": "major",
    "description": "Used to represent an action to send a message, commonly used in a chat UI.",
    "keywords": [
      "send",
      "mail",
      "plane",
      "message",
      "chat"
    ]
  },
  "SettingsMajor": {
    "id": "SettingsMajor",
    "name": "Settings",
    "set": "major",
    "description": "Used to represent settings or a configuration option.",
    "keywords": [
      "configure",
      "settings",
      "cog"
    ]
  },
  "SettingsMinor": {
    "id": "SettingsMinor",
    "name": "Settings",
    "set": "minor",
    "description": "Used to represent settings or a configuration option.",
    "keywords": [
      "configure",
      "settings",
      "cog"
    ]
  },
  "ShareIosMinor": {
    "id": "ShareIosMinor",
    "name": "Share ios",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ShareMinor": {
    "id": "ShareMinor",
    "name": "Share",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ShipmentMajor": {
    "id": "ShipmentMajor",
    "name": "Shipment",
    "set": "major",
    "description": "Used to represent shipping-related events or actions such as shipping labels or tracking information.",
    "keywords": [
      "shipping",
      "shipment",
      "carrier",
      "ship",
      "fulfillment",
      "fulfilment",
      "label",
      "tracking",
      "truck"
    ]
  },
  "ShopcodesMajor": {
    "id": "ShopcodesMajor",
    "name": "Shopcodes",
    "set": "major",
    "description": "Used to represent a QR code.",
    "keywords": [
      "qr code"
    ]
  },
  "SidebarLeftMajor": {
    "id": "SidebarLeftMajor",
    "name": "Sidebar left",
    "set": "major",
    "description": "Used to represent the left section of a component, page or layout.",
    "keywords": [
      "sidebar",
      "layout",
      "section",
      "left",
      "content"
    ]
  },
  "SidebarRightMajor": {
    "id": "SidebarRightMajor",
    "name": "Sidebar right",
    "set": "major",
    "description": "Used to represent the right section of a component, page or layout.",
    "keywords": [
      "sidebar",
      "layout",
      "section",
      "right",
      "content"
    ]
  },
  "SimplifyMajor": {
    "id": "SimplifyMajor",
    "name": "Simplify",
    "set": "major",
    "description": "Action | Used when a merchant simplifies text using AI.",
    "keywords": [
      "simplify",
      "shorten",
      "reduce",
      "summarize"
    ]
  },
  "SimplifyMinor": {
    "id": "SimplifyMinor",
    "name": "Simplify",
    "set": "minor",
    "description": "Action | Used when a merchant simplifies text using AI.",
    "keywords": [
      "simplify",
      "shorten",
      "reduce",
      "summarize"
    ]
  },
  "SlideshowMajor": {
    "id": "SlideshowMajor",
    "name": "Slideshow",
    "set": "major",
    "description": "Used to represent a slideshow or series of images.",
    "keywords": [
      "slides",
      "slideshow",
      "image",
      "photo",
      "picture",
      "thumbnail",
      "dots",
      "swipe"
    ]
  },
  "SmileyHappyMajor": {
    "id": "SmileyHappyMajor",
    "name": "Smiley happy",
    "set": "major",
    "description": "Used to represent a happy customer or user, a smiling face or a smiley emoji.",
    "keywords": [
      "smiley",
      "happy",
      "emoji"
    ]
  },
  "SmileyJoyMajor": {
    "id": "SmileyJoyMajor",
    "name": "Smiley joy",
    "set": "major",
    "description": "Used to represent a very happy customer or user, a smiling face or a smiley emoji.",
    "keywords": [
      "smiley",
      "happy",
      "ecstatic",
      "emoji"
    ]
  },
  "SmileyNeutralMajor": {
    "id": "SmileyNeutralMajor",
    "name": "Smiley neutral",
    "set": "major",
    "description": "Used to represent a neutral customer or user, a neutral face or a neutral emoji.",
    "keywords": [
      "neutral",
      "emoji"
    ]
  },
  "SmileySadMajor": {
    "id": "SmileySadMajor",
    "name": "Smiley sad",
    "set": "major",
    "description": "Used to represent a sad customer or user, a sad face or a sad emoji.",
    "keywords": [
      "sad",
      "emoji"
    ]
  },
  "SocialAdMajor": {
    "id": "SocialAdMajor",
    "name": "Social ad",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SocialPostMajor": {
    "id": "SocialPostMajor",
    "name": "Social post",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SoftPackMajor": {
    "id": "SoftPackMajor",
    "name": "Soft pack",
    "set": "major",
    "description": "Used to represent a soft pack envelope (or bubble mailer) that merchants can use to ship orders to their customers.",
    "keywords": [
      "shipping",
      "packaging",
      "envelope",
      "bubble",
      "mailer",
      "bubblewrap",
      "padded"
    ]
  },
  "SortAscendingMajor": {
    "id": "SortAscendingMajor",
    "name": "Sort ascending",
    "set": "major",
    "description": "Used to indicate that a list of items or resources has been sorted by ascending order.",
    "keywords": [
      "ascending",
      "sort",
      "order"
    ]
  },
  "SortDescendingMajor": {
    "id": "SortDescendingMajor",
    "name": "Sort descending",
    "set": "major",
    "description": "Used to indicate that a list of items or resources has been sorted by descending order.",
    "keywords": [
      "descending",
      "sort",
      "order"
    ]
  },
  "SortMinor": {
    "id": "SortMinor",
    "name": "Sort",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SoundMajor": {
    "id": "SoundMajor",
    "name": "Sound",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "StarFilledMinor": {
    "id": "StarFilledMinor",
    "name": "Star filled",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "star",
      "starred",
      "favourite",
      "favorite"
    ]
  },
  "StarOutlineMinor": {
    "id": "StarOutlineMinor",
    "name": "Star outline",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "favorite",
      "favourite",
      "starred",
      "star"
    ]
  },
  "StatusActiveMajor": {
    "id": "StatusActiveMajor",
    "name": "Active status",
    "set": "major",
    "description": "Used to represent a resource that is in an Active state.",
    "keywords": [
      "active",
      "tick",
      "good",
      "positive",
      "checkmark",
      "circle",
      "round",
      "approve"
    ]
  },
  "StoreMajor": {
    "id": "StoreMajor",
    "name": "Store",
    "set": "major",
    "description": "Used to represent a store or shop.",
    "keywords": [
      "store",
      "shop"
    ]
  },
  "StoreMinor": {
    "id": "StoreMinor",
    "name": "Store",
    "set": "minor",
    "description": "Used to represent a store or shop.",
    "keywords": [
      "store",
      "shop"
    ]
  },
  "StoreStatusMajor": {
    "id": "StoreStatusMajor",
    "name": "Store status",
    "set": "major",
    "description": "Used to represent the activity of a shop or store.",
    "keywords": [
      "status",
      "activity"
    ]
  },
  "TabletMajor": {
    "id": "TabletMajor",
    "name": "Tablet",
    "set": "major",
    "description": "Used to represent a tablet.",
    "keywords": [
      "tablet",
      "ipad"
    ]
  },
  "TapChipMajor": {
    "id": "TapChipMajor",
    "name": "Tap chip",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TaxMajor": {
    "id": "TaxMajor",
    "name": "Tax",
    "set": "major",
    "description": "Used to represent sales tax or a tax receipt.",
    "keywords": [
      "sales tax",
      "tax reciept",
      "tax"
    ]
  },
  "TeamMajor": {
    "id": "TeamMajor",
    "name": "Team",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "connect",
      "connected",
      "path",
      "team",
      "related"
    ]
  },
  "TemplateMajor": {
    "id": "TemplateMajor",
    "name": "Template",
    "set": "major",
    "description": "Used to represent templates.",
    "keywords": [
      "template",
      "theme",
      "section",
      "editor",
      "online store"
    ]
  },
  "TemplateMinor": {
    "id": "TemplateMinor",
    "name": "Template",
    "set": "minor",
    "description": "Used to represent templates.",
    "keywords": [
      "template",
      "theme",
      "section",
      "editor",
      "online store"
    ]
  },
  "TextAlignmentCenterMajor": {
    "id": "TextAlignmentCenterMajor",
    "name": "Text alignment center",
    "set": "major",
    "description": "Icon indicating alignment of text at the center",
    "keywords": [
      "align",
      "alignment",
      "center",
      "rte",
      "text"
    ]
  },
  "TextAlignmentLeftMajor": {
    "id": "TextAlignmentLeftMajor",
    "name": "Text alignment left",
    "set": "major",
    "description": "Icon indicating alignment of text on the left side",
    "keywords": [
      "align",
      "alignment",
      "left",
      "rte",
      "text"
    ]
  },
  "TextAlignmentRightMajor": {
    "id": "TextAlignmentRightMajor",
    "name": "Text alignment right",
    "set": "major",
    "description": "Icon indicating alignment of text on the right side",
    "keywords": [
      "align",
      "alignment",
      "right",
      "rte",
      "text"
    ]
  },
  "TextBlockMajor": {
    "id": "TextBlockMajor",
    "name": "Text block",
    "set": "major",
    "description": "Used to represent a paragraph or block of text.",
    "keywords": [
      "text",
      "paragraph"
    ]
  },
  "TextMajor": {
    "id": "TextMajor",
    "name": "Text",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ThemeEditMajor": {
    "id": "ThemeEditMajor",
    "name": "Theme edit",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ThemeStoreMajor": {
    "id": "ThemeStoreMajor",
    "name": "Theme store",
    "set": "major",
    "description": "Used to represent the Shopify theme store.",
    "keywords": [
      "theme",
      "store",
      "shop",
      "customize"
    ]
  },
  "ThemesMajor": {
    "id": "ThemesMajor",
    "name": "Themes",
    "set": "major",
    "description": "Used to indicate free themes in the Shopify theme store.",
    "keywords": [
      "theme",
      "free",
      "customize"
    ]
  },
  "ThumbsDownMajor": {
    "id": "ThumbsDownMajor",
    "name": "Thumbs down",
    "set": "major",
    "description": "Used to represent an action to dislike or disapprove of something.",
    "keywords": [
      "down",
      "thumbs down",
      "no",
      "downvote",
      "dislike",
      "disapprove",
      "negative",
      "social"
    ]
  },
  "ThumbsDownMinor": {
    "id": "ThumbsDownMinor",
    "name": "Thumbs down",
    "set": "minor",
    "description": "Used to represent an action to dislike or disapprove of something.",
    "keywords": [
      "down",
      "thumbs down",
      "no",
      "downvote",
      "dislike",
      "disapprove",
      "negative",
      "social"
    ]
  },
  "ThumbsUpMajor": {
    "id": "ThumbsUpMajor",
    "name": "Thumbs up",
    "set": "major",
    "description": "Used to represent an action to like or approve of something.",
    "keywords": [
      "social",
      "thumbs up",
      "hand",
      "like",
      "approve",
      "positive",
      "yes",
      "upvote"
    ]
  },
  "ThumbsUpMinor": {
    "id": "ThumbsUpMinor",
    "name": "Thumbs up",
    "set": "minor",
    "description": "Used to represent an action to like or approve of something.",
    "keywords": [
      "social",
      "thumbs up",
      "hand",
      "like",
      "approve",
      "positive",
      "yes",
      "upvote"
    ]
  },
  "TickMinor": {
    "id": "TickMinor",
    "name": "Tick",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "checkmark",
      "yes",
      "ok",
      "good",
      "tick"
    ]
  },
  "TickSmallMinor": {
    "id": "TickSmallMinor",
    "name": "Tick small",
    "set": "minor",
    "description": "Used to denote the action of checking a Polaris checkbox.",
    "keywords": [
      "checkmark",
      "yes",
      "ok",
      "good",
      "passed",
      "tick"
    ]
  },
  "TimeDecayModelMinor": {
    "id": "TimeDecayModelMinor",
    "name": "Time decay attribution model",
    "set": "minor",
    "description": "Used to represent the time decay marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "time decay"
    ]
  },
  "TimelineAttachmentMajor": {
    "id": "TimelineAttachmentMajor",
    "name": "Timeline attachment",
    "set": "major",
    "description": "This icon denotes an attachment of any file to a timeline.",
    "keywords": [
      "timeline",
      "attachment",
      "generic",
      "file"
    ]
  },
  "TipsMajor": {
    "id": "TipsMajor",
    "name": "Tips",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TitleMinor": {
    "id": "TitleMinor",
    "name": "Title",
    "set": "minor",
    "description": "Used to represent a title or heading block appearing as a sub-element of a section, page or layout.",
    "keywords": [
      "title",
      "heading",
      "subheading",
      "content",
      "block"
    ]
  },
  "ToggleMinor": {
    "id": "ToggleMinor",
    "name": "Toggle",
    "set": "minor",
    "description": "Used to dennote something that can be toggled on and off.",
    "keywords": [
      "toggle",
      "setting",
      "switch"
    ]
  },
  "ToolsMajor": {
    "id": "ToolsMajor",
    "name": "Tools",
    "set": "major",
    "description": "Used to represent an action to customize an item or resource.",
    "keywords": [
      "tools",
      "options",
      "settings",
      "customize",
      "configure",
      "pen",
      "pencil",
      "ruler"
    ]
  },
  "TransactionFeeDollarMajor": {
    "id": "TransactionFeeDollarMajor",
    "name": "Transaction fee (dollar)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeEuroMajor": {
    "id": "TransactionFeeEuroMajor",
    "name": "Transaction fee (euro)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeePoundMajor": {
    "id": "TransactionFeePoundMajor",
    "name": "Transaction fee (pound)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeRupeeMajor": {
    "id": "TransactionFeeRupeeMajor",
    "name": "Transaction fee (rupee)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeYenMajor": {
    "id": "TransactionFeeYenMajor",
    "name": "Transaction fee (yen)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionMajor": {
    "id": "TransactionMajor",
    "name": "Transaction",
    "set": "major",
    "description": "Used to represent an action to customize an item or resource.",
    "keywords": [
      "tools",
      "options",
      "settings",
      "customize",
      "configure"
    ]
  },
  "TransferInMajor": {
    "id": "TransferInMajor",
    "name": "Transfer in",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransferMajor": {
    "id": "TransferMajor",
    "name": "Transfer",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransferOutMajor": {
    "id": "TransferOutMajor",
    "name": "Transfer out",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransferWithinShopifyMajor": {
    "id": "TransferWithinShopifyMajor",
    "name": "Transfer within shopify",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransportMajor": {
    "id": "TransportMajor",
    "name": "Transport",
    "set": "major",
    "description": "Used as a navigation item in our emoji picker for the transport category.",
    "keywords": [
      "transport",
      "plane",
      "airplane",
      "emoji",
      "navigation"
    ]
  },
  "TroubleshootMajor": {
    "id": "TroubleshootMajor",
    "name": "Troubleshoot",
    "set": "major",
    "description": "Used to represent an action to troubleshoot or view troubleshooting information.",
    "keywords": [
      "tools",
      "spanner",
      "wrench",
      "troubleshoot"
    ]
  },
  "TypeMajor": {
    "id": "TypeMajor",
    "name": "Type",
    "set": "major",
    "description": "Used to represent a typeface or an action to change the properties of a typeface or body of text.",
    "keywords": [
      "typography",
      "font",
      "typeface",
      "type",
      "letter",
      "text"
    ]
  },
  "TypeMinor": {
    "id": "TypeMinor",
    "name": "Type",
    "set": "minor",
    "description": "Used to represent a typeface or an action to change the properties of a typeface or body of text.",
    "keywords": [
      "typography",
      "font",
      "typeface",
      "type",
      "letter",
      "text"
    ]
  },
  "UndoMajor": {
    "id": "UndoMajor",
    "name": "Undo",
    "set": "major",
    "description": "Used to indicate undoing an action in an editor context.",
    "keywords": [
      "redo",
      "undo",
      "return",
      "cancel"
    ]
  },
  "UnfulfilledMajor": {
    "id": "UnfulfilledMajor",
    "name": "Unfulfilled",
    "set": "major",
    "description": "Used to represent an empty inbox.",
    "keywords": [
      "inbox",
      "unfulilled"
    ]
  },
  "UnknownDeviceMajor": {
    "id": "UnknownDeviceMajor",
    "name": "Unknown device",
    "set": "major",
    "description": "Used to represent an unknown device, item or resource.",
    "keywords": [
      "unknown",
      "device"
    ]
  },
  "UpdateInventoryMajor": {
    "id": "UpdateInventoryMajor",
    "name": "Update inventory",
    "set": "major",
    "description": "Used to represent updated inventory at a warehouse.",
    "keywords": [
      "warehouse",
      "inventory",
      "manage",
      "update"
    ]
  },
  "UploadMajor": {
    "id": "UploadMajor",
    "name": "Upload",
    "set": "major",
    "description": "Used to represent the ability to upload a file",
    "keywords": [
      "upload",
      "file",
      "arrow",
      "up"
    ]
  },
  "VariantMajor": {
    "id": "VariantMajor",
    "name": "Variant",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ViewMajor": {
    "id": "ViewMajor",
    "name": "View",
    "set": "major",
    "description": "Used to represent an action to view something, or to represent an openly viewable item or resource.",
    "keywords": [
      "view",
      "preview",
      "eye",
      "eyeball",
      "look",
      "see",
      "show",
      "reveal"
    ]
  },
  "ViewMinor": {
    "id": "ViewMinor",
    "name": "View",
    "set": "minor",
    "description": "Used to denote the action of previewing an online store.",
    "keywords": [
      "view",
      "preview",
      "eye",
      "eyeball",
      "look",
      "see",
      "show",
      "reveal"
    ]
  },
  "ViewportNarrowMajor": {
    "id": "ViewportNarrowMajor",
    "name": "Viewport narrow",
    "set": "major",
    "description": "Used to represent an action to make a viewport, item or resource narrower.",
    "keywords": [
      "viewport",
      "narrow",
      "arrows",
      "horizontal",
      "left",
      "right"
    ]
  },
  "ViewportShortMajor": {
    "id": "ViewportShortMajor",
    "name": "Viewport short",
    "set": "major",
    "description": "Used to represent an action to make a viewport, item or resource shorter.",
    "keywords": [
      "viewport",
      "short",
      "arrows",
      "vertical",
      "up",
      "down"
    ]
  },
  "ViewportTallMajor": {
    "id": "ViewportTallMajor",
    "name": "Viewport tall",
    "set": "major",
    "description": "Used to represent an action to make a viewport, item or resource taller.",
    "keywords": [
      "viewport",
      "tall",
      "arrows",
      "vertical",
      "up",
      "down"
    ]
  },
  "ViewportWideMajor": {
    "id": "ViewportWideMajor",
    "name": "Viewport wide",
    "set": "major",
    "description": "Used to represent an action to make a viewport, item or resource wider.",
    "keywords": [
      "viewport",
      "wide",
      "arrows",
      "horizontal",
      "left",
      "right"
    ]
  },
  "VocabularyMajor": {
    "id": "VocabularyMajor",
    "name": "Vocabulary",
    "set": "major",
    "description": "Used to represent a book, dictionary or thesaurus.",
    "keywords": [
      "book",
      "thesaurus",
      "dictionary"
    ]
  },
  "VolumeMinor": {
    "id": "VolumeMinor",
    "name": "Volume",
    "set": "minor",
    "description": "Used to represent volume measurement",
    "keywords": [
      "volume",
      "measurement",
      "size"
    ]
  },
  "WandMajor": {
    "id": "WandMajor",
    "name": "Wand",
    "set": "major",
    "description": "Used to represent an action to perform an automatic process or series of processes.",
    "keywords": [
      "magic",
      "wand",
      "automatic"
    ]
  },
  "WandMinor": {
    "id": "WandMinor",
    "name": "Wand",
    "set": "minor",
    "description": "Used to represent an action to perform an automatic process or series of processes.",
    "keywords": [
      "magic",
      "wand",
      "automatic"
    ]
  },
  "WearableMajor": {
    "id": "WearableMajor",
    "name": "Wearable",
    "set": "major",
    "description": "Used to represent a wearable device or wristwatch.",
    "keywords": [
      "wearable",
      "watch",
      "wristwatch"
    ]
  },
  "WeightMinor": {
    "id": "WeightMinor",
    "name": "Weight",
    "set": "minor",
    "description": "Used to represent weight measurement",
    "keywords": [
      "weight",
      "measurement"
    ]
  },
  "WholesaleMajor": {
    "id": "WholesaleMajor",
    "name": "Wholesale",
    "set": "major",
    "description": "Used to represent a forklift or equipment used in a warehouse.",
    "keywords": [
      "forklift",
      "lift",
      "delivery",
      "warehouse"
    ]
  },
  "WifiMajor": {
    "id": "WifiMajor",
    "name": "Wifi",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  }
};

module.exports = metadata;
