'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var TextField = require('../../../TextField/TextField.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function SearchField({
  onChange,
  onClear,
  onFocus,
  onBlur,
  focused,
  value,
  placeholder,
  disabled,
  borderlessQueryField
}) {
  function handleChange(value) {
    onChange(value);
  }

  function handleClear() {
    if (onClear) {
      onClear();
    } else {
      onChange('');
    }
  }

  return /*#__PURE__*/React__default["default"].createElement(TextField.TextField, {
    value: value,
    onChange: handleChange,
    onFocus: onFocus,
    onBlur: onBlur,
    label: placeholder,
    labelHidden: true,
    autoComplete: "off",
    focused: focused,
    placeholder: placeholder,
    clearButton: true,
    onClearButtonClick: handleClear,
    disabled: disabled,
    borderless: borderlessQueryField
  });
}

exports.SearchField = SearchField;
