'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../../../utilities/css.js');
var AlphaTabs = require('../../AlphaTabs.scss.js');
var UnstyledLink = require('../../../UnstyledLink/UnstyledLink.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const Item = /*#__PURE__*/React.memo(function Item({
  id,
  focused,
  children,
  url,
  accessibilityLabel,
  onClick = noop
}) {
  const focusedNode = React.useRef(null);
  React.useEffect(() => {
    if (focusedNode.current && focusedNode.current instanceof HTMLElement && focused) {
      focusedNode.current.focus();
    }
  }, [focusedNode, focused]);
  const classname = css.classNames(AlphaTabs["default"].Item);
  const sharedProps = {
    id,
    ref: focusedNode,
    onClick,
    className: classname,
    'aria-selected': false,
    'aria-label': accessibilityLabel
  };
  const markup = url ? /*#__PURE__*/React__default["default"].createElement(UnstyledLink.UnstyledLink, Object.assign({}, sharedProps, {
    url: url
  }), children) : /*#__PURE__*/React__default["default"].createElement("button", Object.assign({}, sharedProps, {
    ref: focusedNode,
    type: "button"
  }), children);
  return /*#__PURE__*/React__default["default"].createElement("li", null, markup);
});

function noop() {}

exports.Item = Item;
