'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var useToggle = require('../../../../utilities/use-toggle.js');
var BulkActionButton = require('../BulkActionButton/BulkActionButton.js');
var Popover = require('../../../Popover/Popover.js');
var ActionList = require('../../../ActionList/ActionList.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function BulkActionMenu({
  title,
  actions,
  isNewBadgeInBadgeActions
}) {
  const {
    value: isVisible,
    toggle: toggleMenuVisibility
  } = useToggle.useToggle(false);
  return /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, /*#__PURE__*/React__default["default"].createElement(Popover.Popover, {
    active: isVisible,
    activator: /*#__PURE__*/React__default["default"].createElement(BulkActionButton.BulkActionButton, {
      disclosure: true,
      showContentInButton: true,
      onAction: toggleMenuVisibility,
      content: title,
      indicator: isNewBadgeInBadgeActions
    }),
    onClose: toggleMenuVisibility,
    preferInputActivator: true
  }, /*#__PURE__*/React__default["default"].createElement(ActionList.ActionList, {
    items: actions,
    onActionAnyItem: toggleMenuVisibility
  })));
}

exports.BulkActionMenu = BulkActionMenu;
