'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var HorizontalGrid = require('../../../HorizontalGrid/HorizontalGrid.js');
var CloseButton = require('../CloseButton/CloseButton.js');
var Box = require('../../../Box/Box.js');
var HorizontalStack = require('../../../HorizontalStack/HorizontalStack.js');
var Text = require('../../../Text/Text.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function Header({
  id,
  children,
  closing,
  titleHidden,
  onClose
}) {
  const titleHiddenMarkup = /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    position: "absolute",
    insetInlineEnd: "0",
    zIndex: "1"
  }, /*#__PURE__*/React__default["default"].createElement(HorizontalStack.HorizontalStack, {
    gap: "4",
    align: "end",
    blockAlign: "center"
  }, /*#__PURE__*/React__default["default"].createElement(CloseButton.CloseButton, {
    titleHidden: titleHidden,
    onClick: onClose
  })));

  if (titleHidden || !children) {
    return titleHiddenMarkup;
  }

  return /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    paddingBlockStart: "4",
    paddingBlockEnd: "4",
    paddingInlineStart: "5",
    paddingInlineEnd: "5",
    borderBlockEndWidth: "1",
    borderColor: "border-subdued"
  }, /*#__PURE__*/React__default["default"].createElement(HorizontalGrid.HorizontalGrid, {
    columns: {
      xs: '1fr auto'
    },
    gap: "4"
  }, /*#__PURE__*/React__default["default"].createElement(HorizontalStack.HorizontalStack, {
    gap: "4",
    blockAlign: "center"
  }, /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    id: id,
    as: "h2",
    variant: "headingLg",
    breakWord: true
  }, children)), /*#__PURE__*/React__default["default"].createElement(CloseButton.CloseButton, {
    pressed: closing,
    titleHidden: titleHidden,
    onClick: onClose
  })));
}

exports.Header = Header;
