'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../utilities/css.js');
var TextStyle$1 = require('./TextStyle.scss.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

var VariationValue;

(function (VariationValue) {
  VariationValue["Positive"] = "positive";
  VariationValue["Negative"] = "negative";
  VariationValue["Warning"] = "warning";
  VariationValue["Strong"] = "strong";
  VariationValue["Subdued"] = "subdued";
  VariationValue["Code"] = "code";
})(VariationValue || (VariationValue = {}));

/**
 * @deprecated The TextStyle component will be removed in the next
 * major version. Use the Text component instead. See the
 * Polaris component guide on how to use Text.
 *
 * https://polaris.shopify.com/components/text
 */
function TextStyle({
  variation,
  children
}) {
  const className = css.classNames(variation && TextStyle$1["default"][css.variationName('variation', variation)], variation === VariationValue.Code && TextStyle$1["default"].code);
  const Element = variationElement(variation);
  return /*#__PURE__*/React__default["default"].createElement(Element, {
    className: className
  }, children);
}

function variationElement(variation) {
  return variation === VariationValue.Code ? 'code' : 'span';
}

exports.TextStyle = TextStyle;
