'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../../../utilities/css.js');
var shared = require('../../../shared.js');
var TooltipOverlay$1 = require('./TooltipOverlay.scss.js');
var hooks = require('../../../../utilities/i18n/hooks.js');
var PositionedOverlay = require('../../../PositionedOverlay/PositionedOverlay.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function TooltipOverlay({
  active,
  activator,
  preferredPosition = 'above',
  preventInteraction,
  id,
  children,
  accessibilityLabel,
  width,
  padding,
  borderRadius,
  zIndexOverride,
  instant
}) {
  const i18n = hooks.useI18n();
  const markup = active ? /*#__PURE__*/React__default["default"].createElement(PositionedOverlay.PositionedOverlay, {
    active: active,
    activator: activator,
    preferredPosition: preferredPosition,
    preventInteraction: preventInteraction,
    render: renderTooltip,
    zIndexOverride: zIndexOverride
  }) : null;
  return markup;

  function renderTooltip(overlayDetails) {
    const {
      measuring,
      desiredHeight,
      positioning,
      chevronOffset
    } = overlayDetails;
    const containerClassName = css.classNames(TooltipOverlay$1["default"].TooltipOverlay, measuring && TooltipOverlay$1["default"].measuring, !measuring && TooltipOverlay$1["default"].measured, instant && TooltipOverlay$1["default"].instant, positioning === 'above' && TooltipOverlay$1["default"].positionedAbove);
    const contentClassName = css.classNames(TooltipOverlay$1["default"].Content, width && TooltipOverlay$1["default"][width]);
    const contentStyles = measuring ? undefined : {
      minHeight: desiredHeight
    };
    const style = {
      '--pc-tooltip-chevron-x-pos': `${chevronOffset}px`,
      '--pc-tooltip-border-radius': borderRadius ? `var(--p-border-radius-${borderRadius})` : undefined,
      '--pc-tooltip-padding': padding && padding === 'default' ? 'var(--p-space-1) var(--p-space-2)' : `var(--p-space-${padding})`
    };
    return /*#__PURE__*/React__default["default"].createElement("div", Object.assign({
      style: style,
      className: containerClassName
    }, shared.layer.props), /*#__PURE__*/React__default["default"].createElement("div", {
      id: id,
      role: "tooltip",
      className: contentClassName,
      style: { ...contentStyles,
        ...style
      },
      "aria-label": accessibilityLabel ? i18n.translate('Polaris.TooltipOverlay.accessibilityLabel', {
        label: accessibilityLabel
      }) : undefined
    }, children));
  }
}

exports.TooltipOverlay = TooltipOverlay;
