'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function useOnValueChange(value, onChange) {
  const tracked = React__default["default"].useRef(value);
  React.useEffect(() => {
    const oldValue = tracked.current;

    if (value !== tracked.current) {
      tracked.current = value;
      onChange(value, oldValue);
    }
  }, [value, onChange]);
}

exports.useOnValueChange = useOnValueChange;
