import React from 'react';
import { classNames } from '../../../../utilities/css.js';
import styles from './FilterButton.scss.js';
import { UnstyledButton } from '../../../UnstyledButton/UnstyledButton.js';

function FilterButton({
  onClick,
  'aria-label': ariaLabel,
  children,
  disabled
}) {
  const classes = classNames(styles.FilterButton, disabled && styles.Disabled);
  return /*#__PURE__*/React.createElement(UnstyledButton, {
    className: classes,
    onClick: onClick,
    "aria-label": ariaLabel,
    disabled: disabled
  }, children);
}

export { FilterButton };
