"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.nodeRuntimeString = exports.nodeConvertAndSetHeaders = exports.nodeConvertAndSendResponse = exports.nodeConvertIncomingResponse = exports.nodeConvertRequest = void 0;
const http_1 = require("../../runtime/http");
async function nodeConvertRequest(adapterArgs) {
    const req = adapterArgs.rawRequest;
    return {
        headers: (0, http_1.canonicalizeHeaders)({ ...req.headers }),
        method: req.method ?? 'GET',
        // Express.js overrides the url property, so we want to use originalUrl for it
        url: req.originalUrl || req.url,
    };
}
exports.nodeConvertRequest = nodeConvertRequest;
async function nodeConvertIncomingResponse(adapterArgs) {
    return {
        statusCode: adapterArgs.rawResponse.statusCode,
        statusText: adapterArgs.rawResponse.statusMessage,
        headers: (0, http_1.canonicalizeHeaders)(adapterArgs.rawResponse.getHeaders()),
    };
}
exports.nodeConvertIncomingResponse = nodeConvertIncomingResponse;
async function nodeConvertAndSendResponse(response, adapterArgs) {
    const res = adapterArgs.rawResponse;
    if (response.headers) {
        await nodeConvertAndSetHeaders(response.headers, adapterArgs);
    }
    if (response.body) {
        res.write(response.body);
    }
    res.statusCode = response.statusCode;
    res.statusMessage = response.statusText;
    res.end();
}
exports.nodeConvertAndSendResponse = nodeConvertAndSendResponse;
async function nodeConvertAndSetHeaders(headers, adapterArgs) {
    const res = adapterArgs.rawResponse;
    Object.entries(headers).forEach(([header, value]) => res.setHeader(header, value));
}
exports.nodeConvertAndSetHeaders = nodeConvertAndSetHeaders;
function nodeRuntimeString() {
    return `Node ${process.version}`;
}
exports.nodeRuntimeString = nodeRuntimeString;
//# sourceMappingURL=adapter.js.map