"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.webApiRuntimeString = exports.webApiConvertResponse = exports.webApiConvertHeaders = exports.webApiConvertRequest = void 0;
const runtime_1 = require("../../runtime");
async function webApiConvertRequest(adapterArgs) {
    const request = adapterArgs.rawRequest;
    const headers = {};
    for (const [key, value] of request.headers.entries()) {
        (0, runtime_1.addHeader)(headers, key, value);
    }
    return {
        headers,
        method: request.method ?? 'GET',
        url: new URL(request.url).toString(),
    };
}
exports.webApiConvertRequest = webApiConvertRequest;
async function webApiConvertHeaders(headers, _adapterArgs) {
    const remixHeaders = new Headers();
    (0, runtime_1.flatHeaders)(headers ?? {}).forEach(([key, value]) => remixHeaders.append(key, value));
    return Promise.resolve(remixHeaders);
}
exports.webApiConvertHeaders = webApiConvertHeaders;
async function webApiConvertResponse(resp, adapterArgs) {
    return new Response(resp.body, {
        status: resp.statusCode,
        statusText: resp.statusText,
        headers: await webApiConvertHeaders(resp.headers ?? {}, adapterArgs),
    });
}
exports.webApiConvertResponse = webApiConvertResponse;
function webApiRuntimeString() {
    return 'Web API';
}
exports.webApiRuntimeString = webApiRuntimeString;
//# sourceMappingURL=adapter.js.map