import { ConfigInterface } from '../base-types';
import { OAuthBegin, OAuthCallback } from './oauth/oauth';
import { Nonce } from './oauth/nonce';
import { SafeCompare } from './oauth/safe-compare';
import { GetEmbeddedAppUrl, BuildEmbeddedAppUrl } from './get-embedded-app-url';
import { TokenExchange } from './oauth/token-exchange';
export declare function shopifyAuth<Config extends ConfigInterface>(config: Config): ShopifyAuth;
export interface ShopifyAuth {
    begin: OAuthBegin;
    callback: OAuthCallback;
    nonce: Nonce;
    safeCompare: SafeCompare;
    getEmbeddedAppUrl: GetEmbeddedAppUrl;
    buildEmbeddedAppUrl: BuildEmbeddedAppUrl;
    tokenExchange: TokenExchange;
}
//# sourceMappingURL=index.d.ts.map