"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logger = void 0;
const compare_versions_1 = require("compare-versions");
const types_1 = require("../types");
const error_1 = require("../error");
const version_1 = require("../version");
const log_1 = require("./log");
function logger(config) {
    const logFunction = (0, log_1.log)(config);
    return {
        log: logFunction,
        debug: async (message, context = {}) => logFunction(types_1.LogSeverity.Debug, message, context),
        info: async (message, context = {}) => logFunction(types_1.LogSeverity.Info, message, context),
        warning: async (message, context = {}) => logFunction(types_1.LogSeverity.Warning, message, context),
        error: async (message, context = {}) => logFunction(types_1.LogSeverity.Error, message, context),
        deprecated: deprecated(logFunction),
    };
}
exports.logger = logger;
function deprecated(logFunction) {
    return function (version, message) {
        if ((0, compare_versions_1.compare)(version_1.SHOPIFY_API_LIBRARY_VERSION, version, '>=')) {
            throw new error_1.FeatureDeprecatedError(`Feature was deprecated in version ${version}`);
        }
        return logFunction(types_1.LogSeverity.Warning, `[Deprecated | ${version}] ${message}`);
    };
}
//# sourceMappingURL=index.js.map