import { OnlineAccessInfo } from '../auth/oauth/types';
import { AuthScopes } from '../auth/scopes';
import { SessionParams } from './types';
/**
 * Stores App information from logged in merchants so they can make authenticated requests to the Admin API.
 */
export declare class Session {
    static fromPropertyArray(entries: [string, string | number | boolean][], returnUserData?: boolean): Session;
    /**
     * The unique identifier for the session.
     */
    readonly id: string;
    /**
     * The Shopify shop domain, such as `example.myshopify.com`.
     */
    shop: string;
    /**
     * The state of the session. Used for the OAuth authentication code flow.
     */
    state: string;
    /**
     * Whether the access token in the session is online or offline.
     */
    isOnline: boolean;
    /**
     * The desired scopes for the access token, at the time the session was created.
     */
    scope?: string;
    /**
     * The date the access token expires.
     */
    expires?: Date;
    /**
     * The access token for the session.
     */
    accessToken?: string;
    /**
     * Information on the user for the session. Only present for online sessions.
     */
    onlineAccessInfo?: OnlineAccessInfo;
    constructor(params: SessionParams);
    /**
     * Whether the session is active. Active sessions have an access token that is not expired, and has the given scopes.
     */
    isActive(scopes: AuthScopes | string | string[]): boolean;
    /**
     * Whether the access token has the given scopes.
     */
    isScopeChanged(scopes: AuthScopes | string | string[]): boolean;
    /**
     * Whether the access token is expired.
     */
    isExpired(withinMillisecondsOfExpiry?: number): boolean;
    /**
     * Converts an object with data into a Session.
     */
    toObject(): SessionParams;
    /**
     * Checks whether the given session is equal to this session.
     */
    equals(other: Session | undefined): boolean;
    /**
     * Converts the session into an array of key-value pairs.
     */
    toPropertyArray(returnUserData?: boolean): [string, string | number | boolean][];
}
//# sourceMappingURL=session.d.ts.map