"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.FulfillmentService = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class FulfillmentService extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, scope = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "scope": scope, ...otherArgs },
        });
        return response;
    }
}
exports.FulfillmentService = FulfillmentService;
FulfillmentService.apiVersion = types_1.ApiVersion.April23;
FulfillmentService.hasOne = {};
FulfillmentService.hasMany = {};
FulfillmentService.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "fulfillment_services/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "fulfillment_services.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "fulfillment_services/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "fulfillment_services.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "fulfillment_services/<id>.json" }
];
FulfillmentService.resourceNames = [
    {
        "singular": "fulfillment_service",
        "plural": "fulfillment_services"
    }
];
//# sourceMappingURL=fulfillment_service.js.map